/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.stat;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.VisibleForTesting;
import slimeknights.tconstruct.library.tools.nbt.MultiplierNBT;
import slimeknights.tconstruct.library.tools.nbt.StatsNBT;
import slimeknights.tconstruct.library.tools.stat.INumericToolStat;
import slimeknights.tconstruct.library.tools.stat.IToolStat;

public class ModifierStatsBuilder {
    private final Map<IToolStat<?>, Object> map = new HashMap();
    private final Map<INumericToolStat<?>, Float> multipliers = new HashMap();
    private static boolean disableFilter = false;

    public <B> void updateStat(IToolStat<?> stat, Consumer<B> consumer) {
        consumer.accept(this.map.computeIfAbsent(stat, IToolStat::makeBuilder));
    }

    public void multiplier(INumericToolStat<?> stat, double value) {
        this.multipliers.put(stat, Float.valueOf((float)((double)this.multipliers.getOrDefault(stat, Float.valueOf(1.0f)).floatValue() * value)));
    }

    public <T> T getStat(IToolStat<T> stat) {
        Object builder = this.map.get(stat);
        if (builder == null) {
            return stat.getDefaultValue();
        }
        return stat.build(this, this.map.get(stat));
    }

    private <T> void buildStat(StatsNBT.Builder builder, IToolStat<T> stat) {
        T value = stat.build(this, this.map.get(stat));
        if (!value.equals(stat.getDefaultValue())) {
            builder.set(stat, value);
        }
    }

    public float getMultiplier(INumericToolStat<?> stat) {
        return this.multipliers.getOrDefault(stat, Float.valueOf(1.0f)).floatValue();
    }

    public StatsNBT build(@Nullable Item filter) {
        if (this.map.isEmpty()) {
            return StatsNBT.EMPTY;
        }
        StatsNBT.Builder builder = StatsNBT.builder();
        for (IToolStat<?> stat : this.map.keySet()) {
            if (!disableFilter && filter != null && !stat.supports(filter)) continue;
            this.buildStat(builder, stat);
        }
        return builder.build();
    }

    public StatsNBT build() {
        return this.build(null);
    }

    public MultiplierNBT buildMultipliers(@Nullable Item filter) {
        MultiplierNBT.Builder builder = MultiplierNBT.builder();
        for (Map.Entry<INumericToolStat<?>, Float> entry : this.multipliers.entrySet()) {
            INumericToolStat<?> stat = entry.getKey();
            if (!disableFilter && filter != null && !stat.supports(filter)) continue;
            builder.set(stat, entry.getValue().floatValue());
        }
        return builder.build();
    }

    public MultiplierNBT buildMultipliers() {
        return this.buildMultipliers(null);
    }

    @ApiStatus.Internal
    @VisibleForTesting
    public static void disableFilter() {
        disableFilter = true;
    }

    private ModifierStatsBuilder() {
    }

    public static ModifierStatsBuilder builder() {
        return new ModifierStatsBuilder();
    }
}

