/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.modifiers;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import slimeknights.mantle.data.loadable.common.IngredientLoadable;
import slimeknights.mantle.data.loadable.field.ContextKey;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.IntLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.recipe.ICustomOutputRecipe;
import slimeknights.tconstruct.library.json.IntRange;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.recipe.TinkerRecipeTypes;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierRecipeLookup;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class ModifierSalvage
implements ICustomOutputRecipe<Container> {
    public static final RecordLoadable<ModifierSalvage> LOADER = RecordLoadable.create((RecordField)ContextKey.ID.requiredField(), (RecordField)IngredientLoadable.DISALLOW_EMPTY.requiredField("tools", r -> r.toolIngredient), (RecordField)IntLoadable.FROM_ONE.defaultField("max_tool_size", (Object)16, r -> r.maxToolSize), (RecordField)ModifierId.PARSER.requiredField("modifier", r -> r.modifier), ModifierEntry.VALID_LEVEL.defaultField("level", r -> r.level), (RecordField)SlotType.SlotCount.LOADABLE.requiredField("slots", r -> r.slots), ModifierSalvage::new);
    protected final ResourceLocation id;
    protected final Ingredient toolIngredient;
    protected final int maxToolSize;
    protected final ModifierId modifier;
    protected final IntRange level;
    protected final SlotType.SlotCount slots;

    public ModifierSalvage(ResourceLocation id, Ingredient toolIngredient, int maxToolSize, ModifierId modifier, IntRange level, SlotType.SlotCount slots) {
        this.id = id;
        this.toolIngredient = toolIngredient;
        this.maxToolSize = maxToolSize;
        this.modifier = modifier;
        this.level = level;
        this.slots = slots;
        ModifierRecipeLookup.addSalvage(this);
    }

    public boolean matches(ItemStack stack, IToolStackView tool, int originalLevel) {
        return this.level.test(originalLevel) && this.toolIngredient.test(stack);
    }

    public void updateTool(IToolStackView tool) {
        tool.getPersistentData().addSlots(this.slots.type(), this.slots.count());
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)TinkerRecipeTypes.DATA.get();
    }

    @Deprecated
    public boolean m_5818_(Container inv, Level level) {
        return false;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TinkerModifiers.modifierSalvageSerializer.get();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public int getMaxToolSize() {
        return this.maxToolSize;
    }

    public ModifierId getModifier() {
        return this.modifier;
    }
}

