/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world.worldgen.islands;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraftforge.registries.RegistryObject;
import slimeknights.mantle.util.IdExtender;
import slimeknights.tconstruct.world.TinkerStructures;
import slimeknights.tconstruct.world.TinkerWorld;
import slimeknights.tconstruct.world.block.FoliageType;
import slimeknights.tconstruct.world.worldgen.islands.IslandPiece;
import slimeknights.tconstruct.world.worldgen.islands.IslandPlacement;

public class IslandStructure
extends Structure {
    public static final Codec<IslandStructure> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)IslandStructure.m_226567_((RecordCodecBuilder.Instance)inst)).and(inst.group((App)IslandPlacement.CODEC.fieldOf("placement").forGetter(s -> s.placement), (App)SimpleWeightedRandomList.m_146264_((Codec)ResourceLocation.f_135803_).fieldOf("templates").forGetter(s -> s.templates), (App)SimpleWeightedRandomList.m_146264_((Codec)ConfiguredFeature.f_65374_).fieldOf("trees").forGetter(s -> s.trees), (App)BuiltInRegistries.f_256975_.m_194605_().optionalFieldOf("vines").forGetter(s -> s.vines), (App)SimpleWeightedRandomList.m_146264_((Codec)BuiltInRegistries.f_256975_.m_194605_()).fieldOf("grasses").forGetter(s -> s.grasses))).apply((Applicative)inst, IslandStructure::new));
    private final IslandPlacement placement;
    private final SimpleWeightedRandomList<ResourceLocation> templates;
    private final SimpleWeightedRandomList<Holder<ConfiguredFeature<?, ?>>> trees;
    private final Optional<Block> vines;
    private final SimpleWeightedRandomList<Block> grasses;

    public IslandStructure(Structure.StructureSettings settings, IslandPlacement placement, SimpleWeightedRandomList<ResourceLocation> templates, SimpleWeightedRandomList<Holder<ConfiguredFeature<?, ?>>> trees, Optional<Block> vines, SimpleWeightedRandomList<Block> grasses) {
        super(settings);
        this.placement = placement;
        this.templates = templates;
        this.trees = trees;
        this.vines = vines;
        this.grasses = grasses;
    }

    public StructureType<?> m_213658_() {
        return (StructureType)TinkerStructures.island.get();
    }

    @Nullable
    public Block getVines() {
        return this.vines.orElse(null);
    }

    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        return IslandStructure.m_226585_((Structure.GenerationContext)context, (Heightmap.Types)Heightmap.Types.WORLD_SURFACE, builder -> this.generatePieces((StructurePiecesBuilder)builder, context));
    }

    private void generatePieces(StructurePiecesBuilder builder, Structure.GenerationContext context) {
        WorldgenRandom random = context.f_226626_();
        Optional template = this.templates.m_216820_((RandomSource)random);
        if (template.isPresent()) {
            Rotation rotation = Rotation.m_221990_((RandomSource)random);
            int height = this.placement.getHeight(context.f_226628_(), context.f_226622_(), context.f_226629_(), rotation, (RandomSource)random, context.f_226624_());
            BlockPos targetPos = context.f_226628_().m_151394_(height);
            Mirror mirror = (Mirror)Util.m_214670_((Object[])Mirror.values(), (RandomSource)random);
            builder.m_142679_((StructurePiece)new IslandPiece(context.f_226625_(), this, (ResourceLocation)template.get(), targetPos, this.trees.m_216820_((RandomSource)random).map(Holder::m_203334_).orElse(null), rotation, mirror));
        }
    }

    public static Builder seaBuilder() {
        return new Builder(IslandPlacement.SEA);
    }

    public static Builder skyBuilder() {
        return new Builder(IslandPlacement.SKY);
    }

    public IslandPlacement getPlacement() {
        return this.placement;
    }

    public SimpleWeightedRandomList<Block> getGrasses() {
        return this.grasses;
    }

    public static class Builder {
        private static final String[] SIZES = new String[]{"0x1x0", "2x2x4", "4x1x6", "8x1x11", "11x1x11"};
        private final IslandPlacement placement;
        private final SimpleWeightedRandomList.Builder<ResourceLocation> templates = SimpleWeightedRandomList.m_146263_();
        private final SimpleWeightedRandomList.Builder<Holder<ConfiguredFeature<?, ?>>> trees = SimpleWeightedRandomList.m_146263_();
        private final SimpleWeightedRandomList.Builder<Block> grasses = SimpleWeightedRandomList.m_146263_();
        @Nullable
        private Block vines;

        public Builder addTemplate(ResourceLocation template, int weight) {
            this.templates.m_146271_((Object)template, weight);
            return this;
        }

        public Builder addDefaultTemplates(ResourceLocation prefix) {
            for (String size : SIZES) {
                this.addTemplate(IdExtender.LocationExtender.INSTANCE.suffix(prefix, size), 1);
            }
            return this;
        }

        public Builder addTree(Holder<ConfiguredFeature<?, ?>> tree, int weight) {
            this.trees.m_146271_(tree, weight);
            return this;
        }

        public Builder vines(Block block) {
            this.vines = block;
            return this;
        }

        public Builder vines(RegistryObject<? extends Block> block) {
            return this.vines((Block)block.get());
        }

        public Builder addGrass(Block block, int weight) {
            this.grasses.m_146271_((Object)block, weight);
            return this;
        }

        public Builder addGrass(RegistryObject<? extends Block> block, int weight) {
            return this.addGrass((Block)block.get(), weight);
        }

        public Builder addSlimyGrass(FoliageType foliage) {
            this.addGrass((Block)TinkerWorld.slimeTallGrass.get((Enum)foliage), 7);
            this.addGrass((Block)TinkerWorld.slimeFern.get((Enum)foliage), 1);
            return this;
        }

        public IslandStructure build(Structure.StructureSettings settings) {
            return new IslandStructure(settings, this.placement, (SimpleWeightedRandomList<ResourceLocation>)this.templates.m_146270_(), this.trees.m_146270_(), Optional.ofNullable(this.vines), (SimpleWeightedRandomList<Block>)this.grasses.m_146270_());
        }

        private Builder(IslandPlacement placement) {
            this.placement = placement;
        }
    }
}

