/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.utils;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Collection;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeI18n;
import net.minecraftforge.fml.ModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import slimeknights.tconstruct.TConstruct;

public class Util {
    public static final Marker TCONSTRUCT = MarkerManager.getMarker((String)"TCONSTRUCT");
    public static final DecimalFormat COMMA_FORMAT = new DecimalFormat("#,###,###.##", DecimalFormatSymbols.getInstance(Locale.US));
    public static final DecimalFormat PERCENT_FORMAT = new DecimalFormat("#%");
    public static final DecimalFormat BONUS_FORMAT = new DecimalFormat("#.##");
    public static final DecimalFormat MULTIPLIER_FORMAT = new DecimalFormat("#.##x");
    public static final DecimalFormat PERCENT_BOOST_FORMAT = new DecimalFormat("#%");

    public static Logger getLogger(String type) {
        return LogManager.getLogger((String)("tconstruct-" + type));
    }

    public static Optional<String> getCurrentlyActiveExternalMod() {
        return Optional.ofNullable(ModLoadingContext.get().getActiveContainer().getModId()).filter(activeModId -> !"tconstruct".equals(activeModId));
    }

    public static boolean canTranslate(String key) {
        return !ForgeI18n.getPattern((String)key).equals(key);
    }

    public static String makeTranslationKey(String base, @Nullable ResourceLocation name) {
        return net.minecraft.Util.m_137492_((String)base, (ResourceLocation)name);
    }

    public static <T> T make(Supplier<T> supplier) {
        return supplier.get();
    }

    public static <T> T make(T object, Consumer<T> consumer) {
        consumer.accept(object);
        return object;
    }

    public static String toIndentedStringList(Collection<?> list) {
        return list.stream().map(Object::toString).collect(Collectors.joining("\n\t", "\n\t", ""));
    }

    public static int sign(int value) {
        if (value == 0) {
            return 0;
        }
        return value > 0 ? 1 : -1;
    }

    public static Direction directionFromOffset(BlockPos pos, BlockPos neighbor) {
        BlockPos offset = neighbor.m_121996_((Vec3i)pos);
        for (Direction direction : Direction.values()) {
            if (!direction.m_122436_().equals((Object)offset)) continue;
            return direction;
        }
        TConstruct.LOG.error("No direction for position {} and neighbor {}", (Object)pos, (Object)neighbor);
        return Direction.DOWN;
    }

    public static int translateColorBGR(int color) {
        return color & 0xFF00FF00 | (color & 0xFF0000) >> 16 & 0xFF | (color & 0xFF) << 16 & 0xFF0000;
    }

    public static EquipmentSlot getSlotType(InteractionHand hand) {
        return hand == InteractionHand.OFF_HAND ? EquipmentSlot.OFFHAND : EquipmentSlot.MAINHAND;
    }

    public static InteractionHand getOpposite(InteractionHand hand) {
        return hand == InteractionHand.OFF_HAND ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
    }

    public static Vec3 toHitVec(BlockPos pos, Direction sideHit) {
        return new Vec3((double)pos.m_123341_() + 0.5 + (double)sideHit.m_122429_() * 0.5, (double)pos.m_123342_() + 0.5 + (double)sideHit.m_122430_() * 0.5, (double)pos.m_123343_() + 0.5 + (double)sideHit.m_122431_() * 0.5);
    }

    public static BlockHitResult createTraceResult(BlockPos pos, Direction sideHit, boolean empty) {
        return new BlockHitResult(Util.toHitVec(pos, empty ? sideHit.m_122424_() : sideHit), sideHit, pos, false);
    }

    public static <B extends BlockEntity> ClientboundBlockEntityDataPacket createBEPacket(B be, Function<? super B, CompoundTag> tagFunction) {
        return new ClientboundBlockEntityDataPacket(be.m_58899_(), be.m_58903_(), tagFunction.apply(be));
    }

    static {
        BONUS_FORMAT.setPositivePrefix("+");
        PERCENT_BOOST_FORMAT.setPositivePrefix("+");
    }
}

