/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.melting;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import slimeknights.mantle.data.loadable.common.FluidStackLoadable;
import slimeknights.mantle.data.loadable.common.IngredientLoadable;
import slimeknights.mantle.data.loadable.field.ContextKey;
import slimeknights.mantle.data.loadable.field.LoadableField;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.IntLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.recipe.helper.LoadableRecipeSerializer;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.recipe.melting.IMeltingContainer;
import slimeknights.tconstruct.library.recipe.melting.IMeltingRecipe;
import slimeknights.tconstruct.library.recipe.melting.MeltingRecipeLookup;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public class MeltingRecipe
implements IMeltingRecipe {
    protected static final LoadableField<Ingredient, MeltingRecipe> INPUT = IngredientLoadable.DISALLOW_EMPTY.requiredField("ingredient", MeltingRecipe::getInput);
    protected static final LoadableField<FluidStack, MeltingRecipe> OUTPUT = FluidStackLoadable.REQUIRED_STACK_NBT.requiredField("result", MeltingRecipe::getOutput);
    protected static final LoadableField<Integer, MeltingRecipe> TEMPERATURE = IntLoadable.FROM_ZERO.requiredField("temperature", MeltingRecipe::getTemperature);
    protected static final LoadableField<Integer, MeltingRecipe> TIME = IntLoadable.FROM_ONE.requiredField("time", MeltingRecipe::getTime);
    protected static final LoadableField<List<FluidStack>, MeltingRecipe> BYPRODUCTS = FluidStackLoadable.REQUIRED_STACK_NBT.list(0).defaultField("byproducts", List.of(), r -> r.byproducts);
    public static final RecordLoadable<MeltingRecipe> LOADER = RecordLoadable.create((RecordField)ContextKey.ID.requiredField(), (RecordField)LoadableRecipeSerializer.RECIPE_GROUP, INPUT, OUTPUT, TEMPERATURE, TIME, BYPRODUCTS, MeltingRecipe::new);
    private final ResourceLocation id;
    protected final String group;
    protected final Ingredient input;
    protected final FluidStack output;
    protected final int temperature;
    protected final int time;
    protected final List<FluidStack> byproducts;
    private List<List<FluidStack>> outputWithByproducts;

    public MeltingRecipe(ResourceLocation id, String group, Ingredient input, FluidStack output, int temperature, int time, List<FluidStack> byproducts) {
        this(id, group, input, output, temperature, time, byproducts, true);
    }

    public MeltingRecipe(ResourceLocation id, String group, Ingredient input, FluidStack output, int temperature, int time, List<FluidStack> byproducts, boolean addLookup) {
        this.id = id;
        this.group = group;
        this.input = input;
        this.output = output;
        this.temperature = temperature;
        this.time = time;
        this.byproducts = byproducts;
        if (addLookup) {
            MeltingRecipeLookup.addMeltingFluid(input, output, temperature);
        }
    }

    public boolean matches(IMeltingContainer inv, Level world) {
        return this.input.test(inv.getStack());
    }

    @Override
    public int getTemperature(IMeltingContainer inv) {
        return this.temperature;
    }

    @Override
    public int getTime(IMeltingContainer inv) {
        return this.time;
    }

    @Override
    public FluidStack getOutput(IMeltingContainer inv) {
        return this.output.copy();
    }

    public NonNullList<Ingredient> m_7527_() {
        return NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{this.input});
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TinkerSmeltery.meltingSerializer.get();
    }

    @Nullable
    public IMeltingContainer.OreRateType getOreType() {
        return null;
    }

    @Override
    public void handleByproducts(IMeltingContainer inv, IFluidHandler handler) {
        for (FluidStack fluidStack : this.byproducts) {
            handler.fill(fluidStack.copy(), IFluidHandler.FluidAction.EXECUTE);
        }
    }

    public List<List<FluidStack>> getOutputWithByproducts() {
        if (this.outputWithByproducts == null) {
            this.outputWithByproducts = Stream.concat(Stream.of(this.output).map(output -> {
                IMeltingContainer.OreRateType rate = this.getOreType();
                if (rate != null) {
                    return new FluidStack(output, Config.COMMON.foundryOreRate.applyOreBoost(rate, output.getAmount()));
                }
                return output;
            }), this.byproducts.stream()).map(Collections::singletonList).collect(Collectors.toList());
        }
        return this.outputWithByproducts;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public String m_6076_() {
        return this.group;
    }

    public Ingredient getInput() {
        return this.input;
    }

    public FluidStack getOutput() {
        return this.output;
    }

    public int getTemperature() {
        return this.temperature;
    }

    public int getTime() {
        return this.time;
    }
}

