/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world;

import java.util.Collections;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.event.village.WandererTradesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.tools.helper.ToolBuildHandler;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.world.TinkerHeadType;
import slimeknights.tconstruct.world.TinkerWorld;
import slimeknights.tconstruct.world.logic.AncientToolItemListing;

@Mod.EventBusSubscriber(modid="tconstruct", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class WorldEvents {
    @SubscribeEvent
    static void livingVisibility(LivingEvent.LivingVisibilityEvent event) {
        Entity lookingEntity = event.getLookingEntity();
        if (lookingEntity == null) {
            return;
        }
        LivingEntity entity = event.getEntity();
        ItemStack helmet = entity.m_6844_(EquipmentSlot.HEAD);
        Item item = helmet.m_41720_();
        if (item != Items.f_41852_ && TinkerWorld.headItems.contains((Object)item) && lookingEntity.m_6095_() == ((TinkerHeadType)((SkullBlock)((BlockItem)item).m_40614_()).m_48754_()).getType()) {
            event.modifyVisibility(0.5);
        }
    }

    @SubscribeEvent
    static void creeperKill(LivingDropsEvent event) {
        LivingEntity dying;
        TinkerHeadType headType;
        Creeper creeper;
        Entity entity;
        DamageSource source = event.getSource();
        if (source != null && (entity = source.m_7639_()) instanceof Creeper && (creeper = (Creeper)entity).m_32313_() && (headType = TinkerHeadType.fromEntityType((dying = event.getEntity()).m_6095_())) != null && ((Boolean)Config.COMMON.headDrops.get((Object)headType).get()).booleanValue()) {
            creeper.m_32314_();
            event.getDrops().add(dying.m_19998_((ItemLike)TinkerWorld.heads.get((Enum)headType)));
        }
    }

    @SubscribeEvent
    static void livingSpawn(MobSpawnEvent.FinalizeSpawn event) {
        Mob mob = event.getEntity();
        EntityType type = mob.m_6095_();
        ServerLevelAccessor level = event.getLevel();
        if ((type == EntityType.f_20531_ || type == EntityType.f_20511_ || type == EntityType.f_20512_ || type == EntityType.f_20458_ || type == EntityType.f_20530_) && level.m_213780_().m_188501_() < 0.05f) {
            event.setCanceled(true);
            mob.m_6518_(level, level.m_6436_(mob.m_20183_()), event.getSpawnType(), event.getSpawnData(), event.getSpawnTag());
            Item item = mob.m_21205_().m_41720_();
            if (type == EntityType.f_20458_) {
                mob.m_21008_(InteractionHand.MAIN_HAND, ToolBuildHandler.buildItemRandomMaterials((IModifiable)TinkerTools.meltingPan.get(), level.m_213780_()));
            } else if (type == EntityType.f_20530_) {
                mob.m_21008_(InteractionHand.MAIN_HAND, ToolBuildHandler.buildItemRandomMaterials((IModifiable)TinkerTools.warPick.get(), level.m_213780_()));
            } else if (item == Items.f_42430_ || item == Items.f_42433_) {
                mob.m_21008_(InteractionHand.MAIN_HAND, ToolBuildHandler.buildItemRandomMaterials((IModifiable)TinkerTools.battlesign.get(), level.m_213780_()));
            }
        }
    }

    @SubscribeEvent
    static void wanderingTrades(WandererTradesEvent event) {
        int weight = (Integer)Config.COMMON.wandererAncientToolWeight.get();
        if (weight > 0) {
            event.getRareTrades().addAll(Collections.nCopies(weight, AncientToolItemListing.INSTANCE));
        }
    }
}

