/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tables.recipe;

import java.util.Iterator;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialVariant;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.build.ModifierRemovalHook;
import slimeknights.tconstruct.library.recipe.RecipeResult;
import slimeknights.tconstruct.library.recipe.casting.material.MaterialCastingLookup;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationContainer;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationRecipe;
import slimeknights.tconstruct.library.tools.definition.module.material.MaterialRepairModule;
import slimeknights.tconstruct.library.tools.definition.module.material.ToolPartsHook;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.part.IToolPart;
import slimeknights.tconstruct.tables.TinkerTables;

public class TinkerStationPartSwapping
implements ITinkerStationRecipe {
    private static final RecipeResult<ItemStack> TOO_MANY_PARTS = RecipeResult.failure(TConstruct.makeTranslationKey("recipe", "part_swapping.too_many_parts"), new Object[0]);
    protected final ResourceLocation id;

    @Override
    public boolean matches(ITinkerStationContainer inv, Level world) {
        Item item;
        ItemStack tinkerable = inv.getTinkerableStack();
        if (tinkerable.m_41619_() || !tinkerable.m_204117_(TinkerTags.Items.MULTIPART_TOOL) || !((item = tinkerable.m_41720_()) instanceof IModifiable)) {
            return false;
        }
        IModifiable modifiable = (IModifiable)item;
        List<IToolPart> parts = ToolPartsHook.parts(modifiable.getToolDefinition());
        if (parts.isEmpty()) {
            return false;
        }
        boolean foundItem = false;
        for (int i = 0; i < inv.getInputCount(); ++i) {
            ItemStack stack = inv.getInput(i);
            if (stack.m_41619_()) continue;
            if (foundItem) {
                return false;
            }
            Item item2 = stack.m_41720_();
            if (!(item2 instanceof IToolPart) || parts.stream().noneMatch(p -> p.m_5456_() == item2)) {
                return false;
            }
            foundItem = true;
        }
        return foundItem;
    }

    @Override
    public RecipeResult<ItemStack> getValidatedResult(ITinkerStationContainer inv, RegistryAccess access) {
        ToolStack original = inv.getTinkerable();
        List<IToolPart> parts = ToolPartsHook.parts(original.getDefinition());
        if (parts.size() > inv.getInputCount()) {
            return TOO_MANY_PARTS;
        }
        for (int i = 0; i < inv.getInputCount(); ++i) {
            Component error;
            int cost;
            ItemStack stack = inv.getInput(i);
            if (stack.m_41619_()) continue;
            Item item = stack.m_41720_();
            if (!(item instanceof IToolPart)) {
                return RecipeResult.pass();
            }
            IToolPart part = (IToolPart)item;
            MaterialVariantId partVariant = part.getMaterial(stack);
            if (partVariant.equals(IMaterial.UNKNOWN_ID)) {
                return RecipeResult.pass();
            }
            int index = i;
            if ((i >= parts.size() || parts.get(i).m_5456_() != item) && (index = IntStream.range(0, parts.size()).filter(pi -> ((IToolPart)parts.get(pi)).m_5456_() == item).findFirst().orElse(-1)) == -1) {
                return RecipeResult.pass();
            }
            MaterialVariant toolVariant = original.getMaterial(index);
            boolean didChange = !toolVariant.sameVariant(partVariant);
            float repairDurability = MaterialRepairModule.getDurability(null, partVariant.getId(), part.getStatType());
            if (!(didChange || original.getDamage() != 0 && repairDurability != 0.0f)) {
                return RecipeResult.pass();
            }
            ToolStack tool = original.copy();
            if (didChange) {
                tool.replaceMaterial(index, partVariant);
            }
            if (repairDurability > 0.0f && (cost = MaterialCastingLookup.getItemCost(part)) > 0) {
                if ((repairDurability *= (float)cost / 3.0f) > 0.0f) {
                    ModifierEntry entry;
                    Iterator<ModifierEntry> iterator = tool.getModifierList().iterator();
                    while (iterator.hasNext() && !((repairDurability = (entry = iterator.next()).getHook(ModifierHooks.REPAIR_FACTOR).getRepairFactor(tool, entry, repairDurability)) <= 0.0f)) {
                    }
                }
                if (repairDurability > 0.0f) {
                    ToolDamageUtil.repair(tool, (int)repairDurability);
                }
            }
            if ((error = tool.tryValidate()) != null) {
                return RecipeResult.failure(error);
            }
            if (didChange && (error = ModifierRemovalHook.onRemoved(original, tool)) != null) {
                return RecipeResult.failure(error);
            }
            return RecipeResult.success(tool.createStack(Math.min(inv.getTinkerableSize(), this.shrinkToolSlotBy())));
        }
        return RecipeResult.pass();
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TinkerTables.tinkerStationPartSwappingSerializer.get();
    }

    public TinkerStationPartSwapping(ResourceLocation id) {
        this.id = id;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }
}

