/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tables.client.inventory;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.gui.screens.inventory.SmithingScreen;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.joml.Quaternionf;
import slimeknights.mantle.client.SafeClientAccess;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.item.ITinkerStationDisplay;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.utils.TinkerTooltipFlags;
import slimeknights.tconstruct.tables.client.inventory.BaseTabbedScreen;
import slimeknights.tconstruct.tables.client.inventory.module.InfoPanelScreen;
import slimeknights.tconstruct.tables.menu.TabbedContainerMenu;

public abstract class ToolTableScreen<T extends BlockEntity, C extends TabbedContainerMenu<T>>
extends BaseTabbedScreen<T, C> {
    private static final Component MODIFIERS_TEXT = TConstruct.makeTranslation("gui", "tinker_station.modifiers");
    private static final Component UPGRADES_TEXT = TConstruct.makeTranslation("gui", "tinker_station.upgrades");
    private static final Component TRAITS_TEXT = TConstruct.makeTranslation("gui", "tinker_station.traits");
    protected final InfoPanelScreen<ToolTableScreen<T, C>, C> tinkerInfo;
    protected final InfoPanelScreen<ToolTableScreen<T, C>, C> modifierInfo;
    protected final Player player;
    @Nullable
    protected ArmorStand armorStandPreview;
    protected boolean enableArmorStandPreview = true;

    public ToolTableScreen(C c, Inventory playerInventory, Component title) {
        super(c, playerInventory, title);
        this.player = playerInventory.f_35978_;
        this.tinkerInfo = new InfoPanelScreen<ToolTableScreen, C>(this, c, playerInventory, title);
        this.tinkerInfo.setTextScale(0.8888889f);
        this.addModule(this.tinkerInfo);
        this.modifierInfo = new InfoPanelScreen<ToolTableScreen, C>(this, c, playerInventory, title);
        this.modifierInfo.setTextScale(0.7777778f);
        this.addModule(this.modifierInfo);
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        if (this.enableArmorStandPreview) {
            assert (this.f_96541_ != null);
            assert (this.f_96541_.f_91073_ != null);
            this.armorStandPreview = new ArmorStand((Level)this.f_96541_.f_91073_, 0.0, 0.0, 0.0);
            this.armorStandPreview.m_31678_(true);
            this.armorStandPreview.m_31675_(true);
            this.armorStandPreview.f_20883_ = 210.0f;
            this.armorStandPreview.m_146926_(25.0f);
            this.armorStandPreview.f_20885_ = this.armorStandPreview.m_146908_();
            this.armorStandPreview.f_20886_ = this.armorStandPreview.m_146908_();
        }
    }

    protected void renderArmorStand(GuiGraphics graphics, int x, int y, int scale) {
        if (this.armorStandPreview != null) {
            InventoryScreen.m_280432_((GuiGraphics)graphics, (int)(this.cornerX + x), (int)(this.cornerY + y), (int)scale, (Quaternionf)SmithingScreen.f_265867_, null, (LivingEntity)this.armorStandPreview);
        }
    }

    protected void updateArmorStandPreview(ItemStack stack) {
        if (this.armorStandPreview != null) {
            for (EquipmentSlot equipmentslot : EquipmentSlot.values()) {
                this.armorStandPreview.m_8061_(equipmentslot, ItemStack.f_41583_);
            }
            if (!stack.m_41619_()) {
                ItemStack copy = stack.m_41777_();
                Item item = stack.m_41720_();
                if (item instanceof ArmorItem) {
                    ArmorItem armor = (ArmorItem)item;
                    this.armorStandPreview.m_8061_(armor.m_40402_(), copy);
                } else {
                    this.armorStandPreview.m_8061_(EquipmentSlot.OFFHAND, copy);
                }
            }
        }
    }

    protected void updateToolPanel(ToolStack tool, ItemStack result) {
        Item item = tool.getItem();
        if (item instanceof ITinkerStationDisplay) {
            ITinkerStationDisplay display = (ITinkerStationDisplay)item;
            this.tinkerInfo.setCaption(display.getLocalizedName());
            this.tinkerInfo.setText(display.getStatInformation(tool, (Player)Minecraft.m_91087_().f_91074_, new ArrayList<Component>(), SafeClientAccess.getTooltipKey(), TinkerTooltipFlags.TINKER_STATION));
        } else {
            this.tinkerInfo.setCaption(result.m_41786_());
            ArrayList<Component> list = new ArrayList<Component>();
            result.m_41720_().m_7373_(result, (Level)Minecraft.m_91087_().f_91073_, list, (TooltipFlag)TooltipFlag.Default.f_256752_);
            this.tinkerInfo.setText(list);
        }
    }

    protected void updateModifierPanel(ToolStack tool) {
        Component title;
        RegistryAccess access = this.player.m_9236_().m_9598_();
        ArrayList<Component> modifierNames = new ArrayList<Component>();
        ArrayList<Component> modifierTooltip = new ArrayList<Component>();
        if (ToolTableScreen.m_96637_()) {
            title = TRAITS_TEXT;
            Map<Modifier, Integer> upgrades = tool.getUpgrades().getModifiers().stream().collect(Collectors.toMap(ModifierEntry::getModifier, ModifierEntry::getLevel));
            for (ModifierEntry entry : tool.getModifierList()) {
                int level;
                Modifier mod = entry.getModifier();
                if (!mod.shouldDisplay(true) || (level = entry.getLevel() - upgrades.getOrDefault(mod, 0)) <= 0) continue;
                ModifierEntry trait = new ModifierEntry(entry.getModifier(), level);
                modifierNames.add(mod.getDisplayName(tool, trait, access));
                modifierTooltip.add(mod.getDescription(tool, trait));
            }
        } else {
            List<ModifierEntry> modifiers;
            if (ToolTableScreen.m_96638_()) {
                modifiers = tool.getUpgrades().getModifiers();
                title = UPGRADES_TEXT;
            } else {
                modifiers = tool.getModifierList();
                title = MODIFIERS_TEXT;
            }
            for (ModifierEntry entry : modifiers) {
                Modifier mod = entry.getModifier();
                if (!mod.shouldDisplay(true)) continue;
                modifierNames.add(mod.getDisplayName(tool, entry, access));
                modifierTooltip.add(mod.getDescription(tool, entry));
            }
        }
        this.modifierInfo.setCaption(title);
        this.modifierInfo.setText(modifierNames, modifierTooltip);
    }
}

