/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.hook.combat;

import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.world.entity.EquipmentSlot;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.context.LootingContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public interface ArmorLootingModifierHook {
    public int updateArmorLooting(IToolStackView var1, ModifierEntry var2, LootingContext var3, EquipmentContext var4, EquipmentSlot var5, int var6);

    public static int getLooting(@Nullable IToolStackView tool, LootingContext context, int looting) {
        EquipmentSlot lootingSlot = context.getLootingSlot();
        EquipmentContext equipment = tool != null && lootingSlot != null ? EquipmentContext.withTool(context.getHolder(), tool, lootingSlot) : new EquipmentContext(context.getHolder());
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            IToolStackView armor;
            if (slot == lootingSlot || (armor = equipment.getValidTool(slot)) == null) continue;
            for (ModifierEntry entry : armor.getModifierList()) {
                looting = entry.getHook(ModifierHooks.ARMOR_LOOTING).updateArmorLooting(armor, entry, context, equipment, slot, looting);
            }
        }
        return looting;
    }

    public record ComposeMerger(Collection<ArmorLootingModifierHook> modules) implements ArmorLootingModifierHook
    {
        @Override
        public int updateArmorLooting(IToolStackView tool, ModifierEntry modifier, LootingContext context, EquipmentContext equipment, EquipmentSlot slot, int looting) {
            for (ArmorLootingModifierHook module : this.modules) {
                looting = module.updateArmorLooting(tool, modifier, context, equipment, slot, looting);
            }
            return looting;
        }
    }
}

