/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.modifiers;

import com.google.gson.JsonObject;
import com.mojang.math.Transformation;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.util.GsonHelper;
import slimeknights.mantle.client.model.util.MantleItemLayerModel;
import slimeknights.mantle.data.loadable.common.ColorLoadable;
import slimeknights.mantle.util.ItemLayerPixels;
import slimeknights.tconstruct.library.client.modifiers.IBakedModifierModel;
import slimeknights.tconstruct.library.client.modifiers.IUnbakedModifierModel;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public class NormalModifierModel
implements IBakedModifierModel {
    public static final IUnbakedModifierModel UNBAKED_INSTANCE = new Unbaked(-1, 0);
    @Nullable
    private final Material small;
    @Nullable
    private final Material large;
    private final int color;
    private final int luminosity;

    public NormalModifierModel(@Nullable Material smallTexture, @Nullable Material largeTexture) {
        this(smallTexture, largeTexture, -1, 0);
    }

    @Override
    public void addQuads(IToolStackView tool, ModifierEntry entry, Function<Material, TextureAtlasSprite> spriteGetter, Transformation transforms, boolean isLarge, int startTintIndex, Consumer<Collection<BakedQuad>> quadConsumer, @Nullable ItemLayerPixels pixels) {
        Material spriteName;
        Material material = spriteName = isLarge ? this.large : this.small;
        if (spriteName != null) {
            quadConsumer.accept((Collection<BakedQuad>)MantleItemLayerModel.getQuadsForSprite((int)this.color, (int)-1, (TextureAtlasSprite)spriteGetter.apply(spriteName), (Transformation)transforms, (int)this.luminosity, (ItemLayerPixels)pixels));
        }
    }

    public NormalModifierModel(@Nullable Material small, @Nullable Material large, int color, int luminosity) {
        this.small = small;
        this.large = large;
        this.color = color;
        this.luminosity = luminosity;
    }

    private record Unbaked(int color, int luminosity) implements IUnbakedModifierModel
    {
        @Override
        @Nullable
        public IBakedModifierModel forTool(Function<String, Material> smallGetter, Function<String, Material> largeGetter) {
            Material smallTexture = smallGetter.apply("");
            Material largeTexture = largeGetter.apply("");
            if (smallTexture != null || largeTexture != null) {
                return new NormalModifierModel(smallTexture, largeTexture, this.color, this.luminosity);
            }
            return null;
        }

        @Override
        public IUnbakedModifierModel configure(JsonObject data) {
            int color = (Integer)ColorLoadable.ALPHA.getOrDefault(data, "color", (Object)-1);
            int luminosity = GsonHelper.m_13927_((JsonObject)data, (String)"luminosity");
            if (color != this.color || luminosity != this.luminosity) {
                return new Unbaked(color, luminosity);
            }
            return this;
        }
    }
}

