/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world.block;

import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.tags.TagKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.MapColor;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.shared.block.SlimeType;

public enum DirtType implements StringRepresentable
{
    EARTH(Tiers.STONE, MapColor.f_283824_),
    SKY(Tiers.GOLD, MapColor.f_283749_),
    ICHOR(Tiers.IRON, MapColor.f_283791_),
    ENDER(Tiers.DIAMOND, MapColor.f_283895_),
    VANILLA(Tiers.WOOD, MapColor.f_283762_);

    public static final DirtType[] TINKER;
    private final Tiers harvestTier;
    private final MapColor mapColor;
    private final String serializedName = this.name().toLowerCase(Locale.ROOT);
    private final TagKey<Block> blockTag;
    private SlimeType slimeType;

    private DirtType(Tiers harvestTier, MapColor mapColor) {
        this.harvestTier = harvestTier;
        this.mapColor = mapColor;
        this.blockTag = TinkerTags.Blocks.tag("slimy_soil/" + this.m_7912_());
    }

    @Nullable
    public SlimeType asSlime() {
        if (this.slimeType == null && this != VANILLA) {
            this.slimeType = SlimeType.values()[this.ordinal()];
        }
        return this.slimeType;
    }

    public Tiers getHarvestTier() {
        return this.harvestTier;
    }

    public MapColor getMapColor() {
        return this.mapColor;
    }

    public TagKey<Block> getBlockTag() {
        return this.blockTag;
    }

    public SlimeType getSlimeType() {
        return this.slimeType;
    }

    public String m_7912_() {
        return this.serializedName;
    }

    static {
        TINKER = new DirtType[]{EARTH, SKY, ICHOR, ENDER};
    }
}

