/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.recipe;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.Tags;
import slimeknights.mantle.recipe.IMultiRecipe;
import slimeknights.mantle.util.RegistryHelper;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.json.IntRange;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.recipe.RecipeResult;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierRecipeLookup;
import slimeknights.tconstruct.library.recipe.modifiers.adding.IDisplayModifierRecipe;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationContainer;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationRecipe;
import slimeknights.tconstruct.library.tools.item.IModifiableDisplay;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class ArmorDyeingRecipe
implements ITinkerStationRecipe,
IMultiRecipe<IDisplayModifierRecipe> {
    private final ResourceLocation id;
    @Nullable
    private List<IDisplayModifierRecipe> displayRecipes;

    public ArmorDyeingRecipe(ResourceLocation id) {
        this.id = id;
        ModifierRecipeLookup.addRecipeModifier(null, TinkerModifiers.dyed);
    }

    @Override
    public boolean matches(ITinkerStationContainer inv, Level world) {
        if (!inv.getTinkerableStack().m_204117_(TinkerTags.Items.DYEABLE)) {
            return false;
        }
        boolean found = false;
        for (int i = 0; i < inv.getInputCount(); ++i) {
            ItemStack input = inv.getInput(i);
            if (input.m_41619_()) continue;
            if (!input.m_204117_(Tags.Items.DYES)) {
                return false;
            }
            found = true;
        }
        return found;
    }

    @Override
    public RecipeResult<ItemStack> getValidatedResult(ITinkerStationContainer inv, RegistryAccess access) {
        ToolStack tool = inv.getTinkerable().copy();
        ModDataNBT persistentData = tool.getPersistentData();
        ModifierId key = TinkerModifiers.dyed.getId();
        int nr = 0;
        int nb = 0;
        int ng = 0;
        int brightness = 0;
        int count = 0;
        if (persistentData.contains(key, 3)) {
            int color = persistentData.getInt(key);
            int r = color >> 16 & 0xFF;
            int g = color >> 8 & 0xFF;
            int b = color & 0xFF;
            brightness = Math.max(r, Math.max(g, b));
            nr = r;
            nb = b;
            ng = g;
            ++count;
        }
        for (int i = 0; i < inv.getInputCount(); ++i) {
            DyeColor dye;
            ItemStack stack = inv.getInput(i);
            if (stack.m_41619_() || (dye = DyeColor.getColor((ItemStack)stack)) == null) continue;
            float[] color = dye.m_41068_();
            int r = (int)(color[0] * 255.0f);
            int g = (int)(color[1] * 255.0f);
            int b = (int)(color[2] * 255.0f);
            brightness += Math.max(r, Math.max(g, b));
            nr += r;
            ng += g;
            nb += b;
            ++count;
        }
        if (count == 0) {
            return RecipeResult.pass();
        }
        float scaledBrightness = (float)brightness / (float)count;
        brightness = Math.max(nr /= count, Math.max(ng /= count, nb /= count));
        nr = (int)((float)nr * scaledBrightness / (float)brightness);
        ng = (int)((float)ng * scaledBrightness / (float)brightness);
        nb = (int)((float)nb * scaledBrightness / (float)brightness);
        int finalColor = nr << 16 | ng << 8 | nb;
        persistentData.putInt(key, finalColor);
        if (tool.getModifierLevel(key) == 0) {
            tool.addModifier(key, 1);
        }
        return RecipeResult.success(tool.createStack(Math.min(inv.getTinkerableSize(), this.shrinkToolSlotBy())));
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TinkerModifiers.armorDyeingSerializer.get();
    }

    public List<IDisplayModifierRecipe> getRecipes(RegistryAccess access) {
        if (this.displayRecipes == null) {
            List<ItemStack> toolInputs = RegistryHelper.getTagValueStream((Registry)BuiltInRegistries.f_257033_, TinkerTags.Items.DYEABLE).map(IModifiableDisplay::getDisplayStack).toList();
            this.displayRecipes = Arrays.stream(DyeColor.values()).map(dye -> new DisplayRecipe(toolInputs, (DyeColor)dye)).collect(Collectors.toList());
        }
        return this.displayRecipes;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    private static class DisplayRecipe
    implements IDisplayModifierRecipe {
        private static final int[] TINT_COLORS = new int[16];
        private static final IntRange LEVELS = new IntRange(1, 1);
        private final ModifierEntry RESULT = new ModifierEntry(TinkerModifiers.dyed, 1);
        private final List<ItemStack> dyes;
        private final List<ItemStack> toolWithoutModifier;
        private final List<ItemStack> toolWithModifier;
        private final Component variant;

        private static int getTintColor(DyeColor color) {
            int id = color.m_41060_();
            if (TINT_COLORS[id] == 0) {
                float[] colors = color.m_41068_();
                DisplayRecipe.TINT_COLORS[id] = (int)(colors[0] * 255.0f) << 16 | (int)(colors[1] * 255.0f) << 8 | (int)(colors[2] * 255.0f);
            }
            return TINT_COLORS[id];
        }

        public DisplayRecipe(List<ItemStack> tools, DyeColor color) {
            this.toolWithoutModifier = tools;
            this.dyes = RegistryHelper.getTagValueStream((Registry)BuiltInRegistries.f_257033_, (TagKey)color.getTag()).map(ItemStack::new).toList();
            this.variant = Component.m_237115_((String)("color.minecraft." + color.m_7912_()));
            ModifierId id = this.RESULT.getId();
            int tintColor = DisplayRecipe.getTintColor(color);
            List<ModifierEntry> results = List.of(this.RESULT);
            this.toolWithModifier = tools.stream().map(stack -> IDisplayModifierRecipe.withModifiers(stack, results, data -> data.putInt(id, tintColor))).toList();
        }

        @Override
        public ModifierEntry getDisplayResult() {
            return this.RESULT;
        }

        @Override
        public int getInputCount() {
            return 1;
        }

        @Override
        public List<ItemStack> getDisplayItems(int slot) {
            if (slot == 0) {
                return this.dyes;
            }
            return Collections.emptyList();
        }

        @Override
        public IntRange getLevel() {
            return LEVELS;
        }

        @Override
        public List<ItemStack> getToolWithoutModifier() {
            return this.toolWithoutModifier;
        }

        @Override
        public List<ItemStack> getToolWithModifier() {
            return this.toolWithModifier;
        }

        @Override
        public Component getVariant() {
            return this.variant;
        }
    }
}

