/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.json.variable;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.util.Function3;
import io.netty.handler.codec.EncoderException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.data.registry.GenericLoaderRegistry;
import slimeknights.mantle.util.LogicHelper;
import slimeknights.mantle.util.typed.TypedMap;
import slimeknights.tconstruct.library.json.math.ModifierFormula;
import slimeknights.tconstruct.library.json.math.PostFixFormula;
import slimeknights.tconstruct.library.json.variable.VariableFormula;

public record VariableFormulaLoadable<V extends GenericLoaderRegistry.IHaveLoader, F extends VariableFormula<V>>(GenericLoaderRegistry<V> variableLoader, String[] defaultNames, ModifierFormula.FallbackFormula boostFallback, ModifierFormula.FallbackFormula percentFallback, Function3<ModifierFormula, List<V>, Boolean, F> constructor) implements RecordLoadable<F>
{
    public VariableFormulaLoadable(GenericLoaderRegistry<V> variableLoader, String[] defaultNames, Function3<ModifierFormula, List<V>, Boolean, F> constructor) {
        this(variableLoader, defaultNames, ModifierFormula.FallbackFormula.BOOST, ModifierFormula.FallbackFormula.PERCENT, constructor);
    }

    public VariableFormulaLoadable(GenericLoaderRegistry<V> variableLoader, String[] defaultNames, ModifierFormula.FallbackFormula formula, Function3<ModifierFormula, List<V>, Boolean, F> constructor) {
        this(variableLoader, defaultNames, formula, formula, constructor);
    }

    private ModifierFormula.FallbackFormula fallback(boolean percent) {
        return percent ? this.percentFallback : this.boostFallback;
    }

    public F deserialize(JsonObject json, TypedMap context) {
        boolean percent;
        boolean bl = percent = this.boostFallback != this.percentFallback && GsonHelper.m_13855_((JsonObject)json, (String)"percent", (boolean)false);
        if (json.has("variables")) {
            if (!json.has("formula")) {
                throw new JsonSyntaxException("Cannot set variables when not using formula");
            }
            ImmutableList.Builder variables = ImmutableList.builder();
            int index = this.defaultNames.length;
            JsonObject variableObj = GsonHelper.m_13930_((JsonObject)json, (String)"variables");
            String[] newNames = Arrays.copyOf(this.defaultNames, index + variableObj.size());
            for (Map.Entry entry : variableObj.entrySet()) {
                String key = (String)entry.getKey();
                if (LogicHelper.isInList((Object[])this.defaultNames, (Object)key)) {
                    throw new JsonSyntaxException("Variable " + key + " is already defined for this module");
                }
                newNames[index] = key;
                variables.add((Object)this.variableLoader.convert((JsonElement)entry.getValue(), key));
                ++index;
            }
            return (F)((VariableFormula)this.constructor.apply((Object)PostFixFormula.deserialize(json, newNames), (Object)variables.build(), (Object)percent));
        }
        return (F)((VariableFormula)this.constructor.apply((Object)ModifierFormula.deserialize(json, this.defaultNames, this.fallback(percent)), List.of(), (Object)percent));
    }

    public void serialize(F object, JsonObject json) {
        List variables;
        if (this.boostFallback != this.percentFallback) {
            json.addProperty("percent", Boolean.valueOf(object.percent()));
        }
        if (!(variables = object.variables()).isEmpty()) {
            JsonObject variablesObject = new JsonObject();
            GenericLoaderRegistry<V> loader = this.variableLoader();
            String[] variableNames = object.variableNames();
            for (int i = 0; i < variableNames.length; ++i) {
                variablesObject.add(variableNames[i], loader.serialize((GenericLoaderRegistry.IHaveLoader)variables.get(i)));
            }
            json.add("variables", (JsonElement)variablesObject);
        }
        object.formula().serialize(json, this.defaultNames);
    }

    public F decode(FriendlyByteBuf buffer, TypedMap context) {
        boolean percent = this.boostFallback != this.percentFallback && buffer.readBoolean();
        ImmutableList.Builder builder = ImmutableList.builder();
        int size = buffer.m_130242_();
        for (int i = 0; i < size; ++i) {
            builder.add((Object)((GenericLoaderRegistry.IHaveLoader)this.variableLoader.decode(buffer)));
        }
        ImmutableList variables = builder.build();
        return (F)((VariableFormula)this.constructor.apply((Object)ModifierFormula.fromNetwork(buffer, this.defaultNames.length + variables.size(), this.fallback(percent)), (Object)variables, (Object)percent));
    }

    public void encode(FriendlyByteBuf buffer, F object) throws EncoderException {
        if (this.boostFallback != this.percentFallback) {
            buffer.writeBoolean(object.percent());
        }
        List variables = object.variables();
        buffer.m_130130_(variables.size());
        for (GenericLoaderRegistry.IHaveLoader variable : variables) {
            this.variableLoader.encode(buffer, variable);
        }
        object.formula().toNetwork(buffer);
    }
}

