/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tables.menu;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayDeque;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.apache.commons.lang3.tuple.Pair;
import slimeknights.mantle.inventory.EmptyItemHandler;
import slimeknights.mantle.util.RegistryHelper;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.shared.inventory.TriggeringMultiModuleContainerMenu;
import slimeknights.tconstruct.tables.TinkerTables;
import slimeknights.tconstruct.tables.block.ITabbedBlock;
import slimeknights.tconstruct.tables.client.inventory.BaseTabbedScreen;
import slimeknights.tconstruct.tables.menu.module.SideInventoryContainer;

public class TabbedContainerMenu<TILE extends BlockEntity>
extends TriggeringMultiModuleContainerMenu<TILE> {
    private static final TinkerBlockComp COMPARATOR = new TinkerBlockComp();
    public final List<Pair<BlockPos, BlockState>> stationBlocks = Lists.newLinkedList();

    public TabbedContainerMenu(MenuType<?> containerType, int id, @Nullable Inventory inv, @Nullable TILE tile) {
        super(containerType, id, inv, tile);
        if (tile != null && tile.m_58904_() != null) {
            this.detectStationParts(tile.m_58904_(), tile.m_58899_());
        }
    }

    public void detectStationParts(Level world, BlockPos start) {
        HashSet visited = Sets.newHashSet();
        ArrayDeque<BlockPos> queue = new ArrayDeque<BlockPos>();
        queue.add(start);
        while (!queue.isEmpty()) {
            BlockState state;
            BlockPos pos = (BlockPos)queue.poll();
            if (visited.contains(pos) || !((state = world.m_8055_(pos)).m_60734_() instanceof ITabbedBlock)) continue;
            for (Direction direction : Direction.values()) {
                BlockPos offset = pos.m_121945_(direction);
                if (visited.contains(offset)) continue;
                queue.add(offset);
            }
            visited.add(pos);
            this.stationBlocks.add((Pair<BlockPos, BlockState>)Pair.of((Object)pos, (Object)state));
            if (this.stationBlocks.size() < 6) continue;
            break;
        }
        this.stationBlocks.sort(COMPARATOR);
    }

    protected void addChestSideInventory() {
        if (this.tile == null || this.inv == null) {
            return;
        }
        Level world = this.tile.m_58904_();
        if (world != null) {
            BlockEntity inventoryTE = null;
            Direction accessDir = null;
            BlockPos pos = this.tile.m_58899_();
            block0: for (Direction dir : Direction.Plane.HORIZONTAL) {
                BlockPos neighbor = pos.m_121945_(dir);
                for (Pair<BlockPos, BlockState> tinkerPos : this.stationBlocks) {
                    if (!((BlockPos)tinkerPos.getLeft()).equals((Object)neighbor)) continue;
                    continue block0;
                }
                BlockEntity te = world.m_7702_(neighbor);
                if (te == null || !TabbedContainerMenu.isUsable(te, this.inv.f_35978_)) continue;
                if (TabbedContainerMenu.hasItemHandler(te, null)) {
                    inventoryTE = te;
                    break;
                }
                Direction side = dir.m_122424_();
                if (!TabbedContainerMenu.hasItemHandler(te, side)) continue;
                inventoryTE = te;
                accessDir = side;
                break;
            }
            if (inventoryTE != null) {
                int invSlots = ((IItemHandler)inventoryTE.getCapability(ForgeCapabilities.ITEM_HANDLER, accessDir).orElse((Object)EmptyItemHandler.INSTANCE)).getSlots();
                int columns = Mth.m_14045_((int)((invSlots - 1) / 9 + 1), (int)3, (int)6);
                this.addSubContainer((AbstractContainerMenu)new SideInventoryContainer<BlockEntity>((MenuType)TinkerTables.craftingStationContainer.get(), this.f_38840_, this.inv, inventoryTE, accessDir, -114, 8, columns), false);
            }
        }
    }

    private static boolean isUsable(BlockEntity tileEntity, Player player) {
        return !RegistryHelper.contains((Registry)BuiltInRegistries.f_257049_, TinkerTags.TileEntityTypes.CRAFTING_STATION_BLACKLIST, (Object)tileEntity.m_58903_()) && (!(tileEntity instanceof Container) || ((Container)tileEntity).m_6542_(player));
    }

    private static boolean hasItemHandler(BlockEntity tileEntity, @Nullable Direction direction) {
        return tileEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, direction).filter(cap -> cap instanceof IItemHandlerModifiable).isPresent();
    }

    public void updateScreen() {
        if (this.tile != null && this.tile.m_58904_() != null && this.tile.m_58904_().f_46443_ && FMLEnvironment.dist == Dist.CLIENT) {
            ClientOnly.clientScreenUpdate();
        }
    }

    public void error(MutableComponent message) {
        if (this.tile != null && this.tile.m_58904_() != null && this.tile.m_58904_().f_46443_ && FMLEnvironment.dist == Dist.CLIENT) {
            ClientOnly.clientError(message);
        }
    }

    public void warning(MutableComponent message) {
        if (this.tile != null && this.tile.m_58904_() != null && this.tile.m_58904_().f_46443_ && FMLEnvironment.dist == Dist.CLIENT) {
            ClientOnly.clientWarning(message);
        }
    }

    private static class TinkerBlockComp
    implements Comparator<Pair<BlockPos, BlockState>> {
        private TinkerBlockComp() {
        }

        @Override
        public int compare(Pair<BlockPos, BlockState> o1, Pair<BlockPos, BlockState> o2) {
            int sum2;
            BlockPos pos1 = (BlockPos)o1.getLeft();
            BlockPos pos2 = (BlockPos)o2.getLeft();
            int sum1 = pos1.m_123341_() + pos1.m_123342_() + pos1.m_123343_();
            if (sum1 != (sum2 = pos2.m_123341_() + pos2.m_123342_() + pos2.m_123343_())) {
                return Integer.compare(sum1, sum2);
            }
            if (pos1.m_123342_() != pos2.m_123342_()) {
                return Integer.compare(pos1.m_123342_(), pos2.m_123342_());
            }
            if (pos1.m_123341_() != pos2.m_123341_()) {
                return Integer.compare(pos1.m_123341_(), pos2.m_123341_());
            }
            return Integer.compare(pos1.m_123343_(), pos2.m_123343_());
        }
    }

    private static class ClientOnly {
        private ClientOnly() {
        }

        private static void clientScreenUpdate() {
            Screen screen = Minecraft.m_91087_().f_91080_;
            if (screen instanceof BaseTabbedScreen) {
                ((BaseTabbedScreen)screen).updateDisplay();
            }
        }

        private static void clientError(MutableComponent errorMessage) {
            Screen screen = Minecraft.m_91087_().f_91080_;
            if (screen instanceof BaseTabbedScreen) {
                ((BaseTabbedScreen)screen).error((Component)errorMessage);
            }
        }

        private static void clientWarning(MutableComponent warningMessage) {
            Screen screen = Minecraft.m_91087_().f_91080_;
            if (screen instanceof BaseTabbedScreen) {
                ((BaseTabbedScreen)screen).warning((Component)warningMessage);
            }
        }
    }
}

