/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.client.render.FluidCuboid;
import slimeknights.mantle.client.render.FluidRenderer;
import slimeknights.mantle.client.render.MantleRenderTypes;
import slimeknights.mantle.client.render.RenderingHelper;
import slimeknights.tconstruct.smeltery.block.ChannelBlock;
import slimeknights.tconstruct.smeltery.block.entity.ChannelBlockEntity;
import slimeknights.tconstruct.smeltery.client.render.ChannelFluids;

public class ChannelBlockEntityRenderer
implements BlockEntityRenderer<ChannelBlockEntity> {
    public ChannelBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(ChannelBlockEntity te, float partialTicks, PoseStack matrices, MultiBufferSource buffer, int light, int combinedOverlayIn) {
        FluidCuboid cube;
        boolean isRotated;
        FluidStack fluid = te.getFluid();
        if (fluid.isEmpty()) {
            return;
        }
        Level world = te.m_58904_();
        if (world == null) {
            return;
        }
        BlockPos pos = te.m_58899_();
        BlockState state = te.m_58900_();
        ChannelFluids model = (ChannelFluids)ChannelFluids.REGISTRY.get((Object)state.m_60734_());
        if (model == null) {
            return;
        }
        IClientFluidTypeExtensions attributes = IClientFluidTypeExtensions.of((Fluid)fluid.getFluid());
        TextureAtlasSprite still = FluidRenderer.getBlockSprite((ResourceLocation)attributes.getStillTexture(fluid));
        TextureAtlasSprite flowing = FluidRenderer.getBlockSprite((ResourceLocation)attributes.getFlowingTexture(fluid));
        VertexConsumer builder = buffer.m_6299_(MantleRenderTypes.FLUID);
        int color = attributes.getTintColor(fluid);
        light = FluidRenderer.withBlockLight((int)light, (int)fluid.getFluid().getFluidType().getLightLevel(fluid));
        Direction centerFlow = Direction.UP;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            ChannelBlock.ChannelConnection connection = (ChannelBlock.ChannelConnection)((Object)state.m_61143_((Property)ChannelBlock.DIRECTION_MAP.get(direction)));
            if (!connection.canFlow()) continue;
            isRotated = RenderingHelper.applyRotation((PoseStack)matrices, (Direction)direction);
            if (te.isFlowing(direction)) {
                cube = model.sideFlow(connection == ChannelBlock.ChannelConnection.OUT);
                if (connection == ChannelBlock.ChannelConnection.OUT) {
                    if (centerFlow == Direction.UP) {
                        centerFlow = direction;
                    } else if (centerFlow != direction) {
                        centerFlow = Direction.DOWN;
                    }
                }
                if (!world.m_8055_(pos.m_121945_(direction)).m_60713_(state.m_60734_())) {
                    FluidRenderer.renderCuboid((PoseStack)matrices, (VertexConsumer)builder, (FluidCuboid)model.sideEdge(), (float)0.0f, (TextureAtlasSprite)still, (TextureAtlasSprite)flowing, (int)color, (int)light, (boolean)false);
                }
            } else {
                cube = model.sideStill();
            }
            FluidRenderer.renderCuboid((PoseStack)matrices, (VertexConsumer)builder, (FluidCuboid)cube, (float)0.0f, (TextureAtlasSprite)still, (TextureAtlasSprite)flowing, (int)color, (int)light, (boolean)false);
            if (!isRotated) continue;
            matrices.m_85849_();
        }
        isRotated = false;
        if (centerFlow.m_122434_().m_122478_()) {
            cube = model.center(false);
        } else {
            cube = model.center(true);
            isRotated = RenderingHelper.applyRotation((PoseStack)matrices, (Direction)centerFlow);
        }
        FluidRenderer.renderCuboid((PoseStack)matrices, (VertexConsumer)builder, (FluidCuboid)cube, (float)0.0f, (TextureAtlasSprite)still, (TextureAtlasSprite)flowing, (int)color, (int)light, (boolean)false);
        if (isRotated) {
            matrices.m_85849_();
        }
        if (((Boolean)state.m_61143_((Property)ChannelBlock.DOWN)).booleanValue() && te.isFlowing(Direction.DOWN)) {
            cube = model.down();
            FluidRenderer.renderCuboid((PoseStack)matrices, (VertexConsumer)builder, (FluidCuboid)cube, (float)0.0f, (TextureAtlasSprite)still, (TextureAtlasSprite)flowing, (int)color, (int)light, (boolean)false);
            RenderingHelper.renderFaucetFluids((LevelAccessor)world, (BlockPos)pos, (Direction)Direction.DOWN, (PoseStack)matrices, (VertexConsumer)builder, (TextureAtlasSprite)still, (TextureAtlasSprite)flowing, (int)color, (int)light);
        }
    }
}

