/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.modules.build;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.IntLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.data.registry.GenericLoaderRegistry;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.build.ModifierRemovalHook;
import slimeknights.tconstruct.library.modifiers.hook.build.VolatileDataModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.DisplayNameModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.modifiers.modules.util.ModifierCondition;
import slimeknights.tconstruct.library.modifiers.util.ModuleWithKey;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.nbt.IToolContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;

public record SwappableSlotModule(@Nullable ResourceLocation key, int slotCount, ModifierCondition<IToolContext> condition) implements VolatileDataModifierHook,
DisplayNameModifierHook,
ModifierRemovalHook,
ModifierModule,
ModuleWithKey,
ModifierCondition.ConditionalModule<IToolContext>
{
    private static final List<ModuleHook<?>> DEFAULT_HOOKS = HookProvider.defaultHooks(ModifierHooks.VOLATILE_DATA, ModifierHooks.DISPLAY_NAME, ModifierHooks.REMOVE);
    public static final String FORMAT = TConstruct.makeTranslationKey("modifier", "extra_modifier.type_format");
    public static final RecordLoadable<SwappableSlotModule> LOADER = RecordLoadable.create(ModuleWithKey.FIELD, (RecordField)IntLoadable.ANY_SHORT.requiredField("slots", SwappableSlotModule::slotCount), ModifierCondition.CONTEXT_FIELD, SwappableSlotModule::new);

    public SwappableSlotModule(@Nullable ResourceLocation key, int slotCount) {
        this(key, slotCount, ModifierCondition.ANY_CONTEXT);
    }

    public SwappableSlotModule(int slotCount) {
        this(null, slotCount);
    }

    @Override
    public Component getDisplayName(IToolStackView tool, ModifierEntry entry, Component name, @Nullable RegistryAccess access) {
        SlotType type;
        String slotName = tool.getPersistentData().getString(this.getKey(entry.getModifier()));
        if (!slotName.isEmpty() && (type = SlotType.getIfPresent(slotName)) != null) {
            return Component.m_237110_((String)FORMAT, (Object[])new Object[]{name.m_6879_(), type.getDisplayName()}).m_130938_(style -> style.m_131148_(type.getColor()));
        }
        return name;
    }

    @Override
    public Integer getPriority() {
        return 50;
    }

    @Override
    public void addVolatileData(IToolContext context, ModifierEntry modifier, ModDataNBT volatileData) {
        SlotType type;
        String slotName;
        if (this.condition.matches(context, modifier) && !(slotName = context.getPersistentData().getString(this.getKey(modifier.getModifier()))).isEmpty() && (type = SlotType.getIfPresent(slotName)) != null) {
            volatileData.addSlots(type, this.slotCount);
        }
    }

    @Override
    @Nullable
    public Component onRemoved(IToolStackView tool, Modifier modifier) {
        tool.getPersistentData().remove(this.getKey(modifier));
        return null;
    }

    @Override
    public List<ModuleHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    public GenericLoaderRegistry.IGenericLoader<? extends ModifierModule> getLoader() {
        return LOADER;
    }

    public record BonusSlot(@Nullable ResourceLocation key, SlotType match, SlotType bonus, int slotCount, ModifierCondition<IToolContext> condition) implements VolatileDataModifierHook,
    ModifierModule,
    ModuleWithKey,
    ModifierCondition.ConditionalModule<IToolContext>
    {
        private static final List<ModuleHook<?>> DEFAULT_HOOKS = List.of(ModifierHooks.VOLATILE_DATA);
        public static final RecordLoadable<BonusSlot> LOADER = RecordLoadable.create(ModuleWithKey.FIELD, (RecordField)SlotType.LOADABLE.requiredField("match", BonusSlot::match), (RecordField)SlotType.LOADABLE.requiredField("bonus", BonusSlot::bonus), (RecordField)IntLoadable.ANY_SHORT.requiredField("slots", BonusSlot::slotCount), ModifierCondition.CONTEXT_FIELD, BonusSlot::new);

        public BonusSlot(@Nullable ResourceLocation key, SlotType match, SlotType bonus, int slotCount) {
            this(key, match, bonus, slotCount, ModifierCondition.ANY_CONTEXT);
        }

        public BonusSlot(SlotType match, SlotType penalty, int slotCount) {
            this(null, match, penalty, slotCount);
        }

        @Override
        public void addVolatileData(IToolContext context, ModifierEntry modifier, ModDataNBT volatileData) {
            String slotName;
            if (this.condition.matches(context, modifier) && !(slotName = context.getPersistentData().getString(this.getKey(modifier.getModifier()))).isEmpty() && this.match.getName().equals(slotName)) {
                volatileData.addSlots(this.bonus, this.slotCount);
            }
        }

        @Override
        public List<ModuleHook<?>> getDefaultHooks() {
            return DEFAULT_HOOKS;
        }

        public GenericLoaderRegistry.IGenericLoader<? extends ModifierModule> getLoader() {
            return LOADER;
        }
    }
}

