/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.fluid.entity;

import net.minecraft.world.entity.Entity;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.IntLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.library.modifiers.fluid.EffectLevel;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffect;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffectContext;
import slimeknights.tconstruct.library.modifiers.fluid.TimeAction;

public record FreezeFluidEffect(TimeAction action, int time) implements FluidEffect<FluidEffectContext.Entity>
{
    public static final RecordLoadable<FreezeFluidEffect> LOADER = RecordLoadable.create((RecordField)TimeAction.LOADABLE.requiredField("action", e -> e.action), (RecordField)IntLoadable.FROM_ONE.requiredField("time", e -> e.time), FreezeFluidEffect::new);

    public RecordLoadable<FreezeFluidEffect> getLoader() {
        return LOADER;
    }

    @Override
    public float apply(FluidStack fluid, EffectLevel level, FluidEffectContext.Entity context, IFluidHandler.FluidAction action) {
        Entity target = context.getTarget();
        if (!target.m_142079_()) {
            return 0.0f;
        }
        if (this.action == TimeAction.ADD) {
            float value = level.value();
            if (action.execute()) {
                target.m_146917_(Math.max(target.m_146891_(), target.m_146888_()) + Math.round((float)this.time * value));
                target.m_7311_(0);
            }
            return value;
        }
        int freezeTicks = target.m_146891_();
        int frozen = target.m_146888_();
        float existing = frozen < freezeTicks ? 0.0f : (float)(frozen - freezeTicks) / (float)this.time;
        float effective = level.effective(existing);
        if (action.execute()) {
            target.m_146917_(freezeTicks + Math.round((float)this.time * effective));
            target.m_7311_(0);
        }
        return effective - existing;
    }
}

