/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.data.material;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.data.ExistingFileHelper;
import slimeknights.mantle.data.GenericDataProvider;
import slimeknights.mantle.data.loadable.common.ColorLoadable;
import slimeknights.tconstruct.library.client.data.material.AbstractMaterialSpriteProvider;
import slimeknights.tconstruct.library.client.data.material.MaterialPartTextureGenerator;
import slimeknights.tconstruct.library.client.materials.MaterialRenderInfoJson;
import slimeknights.tconstruct.library.client.materials.MaterialRenderInfoLoader;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;

public abstract class AbstractMaterialRenderInfoProvider
extends GenericDataProvider {
    private final Map<MaterialVariantId, RenderInfoBuilder> allRenderInfo = new HashMap<MaterialVariantId, RenderInfoBuilder>();
    @Nullable
    private final AbstractMaterialSpriteProvider materialSprites;
    @Nullable
    private final ExistingFileHelper existingFileHelper;

    public AbstractMaterialRenderInfoProvider(PackOutput packOutput, @Nullable AbstractMaterialSpriteProvider materialSprites, @Nullable ExistingFileHelper existingFileHelper) {
        super(packOutput, PackOutput.Target.RESOURCE_PACK, "tinkering/materials", MaterialRenderInfoLoader.GSON);
        this.materialSprites = materialSprites;
        this.existingFileHelper = existingFileHelper;
    }

    public AbstractMaterialRenderInfoProvider(PackOutput packOutput) {
        this(packOutput, null, null);
    }

    protected abstract void addMaterialRenderInfo();

    public CompletableFuture<?> m_213708_(CachedOutput cache) {
        if (this.existingFileHelper != null) {
            MaterialPartTextureGenerator.runCallbacks(this.existingFileHelper, null);
        }
        this.addMaterialRenderInfo();
        return AbstractMaterialRenderInfoProvider.allOf(this.allRenderInfo.entrySet().stream().map(entry -> this.saveJson(cache, ((MaterialVariantId)entry.getKey()).getLocation('/'), ((RenderInfoBuilder)entry.getValue()).build()))).thenRunAsync(() -> {
            if (this.existingFileHelper != null) {
                MaterialPartTextureGenerator.runCallbacks(null, null);
            }
        });
    }

    private RenderInfoBuilder getBuilder(ResourceLocation texture) {
        AbstractMaterialSpriteProvider.MaterialSpriteInfo spriteInfo;
        RenderInfoBuilder builder = new RenderInfoBuilder();
        if (this.materialSprites != null && (spriteInfo = this.materialSprites.getMaterialInfo(texture)) != null) {
            int color;
            String[] fallbacks = spriteInfo.getFallbacks();
            if (fallbacks.length > 0) {
                builder.fallbacks(fallbacks);
            }
            if ((color = spriteInfo.getTransformer().getFallbackColor()) != -1) {
                builder.color(color & 0xFF00 | color >> 16 & 0xFF | color << 16 & 0xFF0000);
            }
            builder.generator(spriteInfo);
        }
        return builder;
    }

    protected RenderInfoBuilder buildRenderInfo(MaterialVariantId materialId) {
        return this.allRenderInfo.computeIfAbsent(materialId, id -> this.getBuilder(materialId.getLocation('_')));
    }

    protected RenderInfoBuilder buildRenderInfo(MaterialVariantId materialId, ResourceLocation texture) {
        return this.allRenderInfo.computeIfAbsent(materialId, id -> this.getBuilder(texture).texture(texture));
    }

    protected static class RenderInfoBuilder {
        private ResourceLocation texture = null;
        private String[] fallbacks;
        private int color = -1;
        private boolean skipUniqueTexture;
        private int luminosity = 0;
        private MaterialRenderInfoJson.MaterialGeneratorJson generator = null;

        protected RenderInfoBuilder() {
        }

        public RenderInfoBuilder color(int color) {
            if ((color & 0xFF000000) == 0) {
                color |= 0xFF000000;
            }
            this.color = color;
            return this;
        }

        public RenderInfoBuilder fallbacks(String ... fallbacks) {
            this.fallbacks = fallbacks;
            return this;
        }

        public RenderInfoBuilder materialTexture(MaterialVariantId variantId) {
            return this.texture(variantId.getLocation('_'));
        }

        public MaterialRenderInfoJson build() {
            return new MaterialRenderInfoJson(this.texture, this.fallbacks, ColorLoadable.ALPHA.getString((Object)this.color), this.skipUniqueTexture ? Boolean.TRUE : null, this.luminosity, this.generator);
        }

        public RenderInfoBuilder texture(ResourceLocation texture) {
            this.texture = texture;
            return this;
        }

        public RenderInfoBuilder skipUniqueTexture(boolean skipUniqueTexture) {
            this.skipUniqueTexture = skipUniqueTexture;
            return this;
        }

        public RenderInfoBuilder luminosity(int luminosity) {
            this.luminosity = luminosity;
            return this;
        }

        public RenderInfoBuilder generator(MaterialRenderInfoJson.MaterialGeneratorJson generator) {
            this.generator = generator;
            return this;
        }
    }
}

