/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modules.ranged;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.json.SingletonRecordLoadable;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.interaction.GeneralInteractionModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.InteractionSource;
import slimeknights.tconstruct.library.modifiers.hook.ranged.BowAmmoModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.tools.capability.inventory.ToolInventoryCapability;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;

public enum TrickQuiverModule implements ModifierModule,
BowAmmoModifierHook,
GeneralInteractionModifierHook
{
    INSTANCE;

    public static final SingletonRecordLoadable<TrickQuiverModule> LOADER;
    private static final List<ModuleHook<?>> DEFAULT_HOOKS;
    private static final ResourceLocation SELECTED_SLOT;
    private static final Component DISABLED;
    private static final String EMPTY;
    private static final String SELECTED;

    public RecordLoadable<TrickQuiverModule> getLoader() {
        return LOADER;
    }

    @Override
    public List<ModuleHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    @Override
    public ItemStack findAmmo(IToolStackView tool, ModifierEntry modifier, LivingEntity shooter, ItemStack standardAmmo, Predicate<ItemStack> ammoPredicate) {
        return modifier.getHook(ToolInventoryCapability.HOOK).getStack(tool, modifier, tool.getPersistentData().getInt(SELECTED_SLOT));
    }

    @Override
    public void shrinkAmmo(IToolStackView tool, ModifierEntry modifier, LivingEntity shooter, ItemStack ammo, int needed) {
        ammo.m_41774_(needed);
        modifier.getHook(ToolInventoryCapability.HOOK).setStack(tool, modifier, tool.getPersistentData().getInt(SELECTED_SLOT), ammo);
    }

    @Override
    public InteractionResult onToolUse(IToolStackView tool, ModifierEntry modifier, Player player, InteractionHand hand, InteractionSource source) {
        if (!player.m_6047_()) {
            if (!player.m_9236_().f_46443_) {
                ModDataNBT data = tool.getPersistentData();
                ToolInventoryCapability.InventoryModifierHook inventory = modifier.getHook(ToolInventoryCapability.HOOK);
                int totalSlots = inventory.getSlots(tool, modifier);
                int newSelected = (data.getInt(SELECTED_SLOT) + 1) % (totalSlots + 1);
                data.putInt(SELECTED_SLOT, newSelected);
                if (newSelected == totalSlots) {
                    player.m_5661_(DISABLED, true);
                } else {
                    ItemStack selectedStack = inventory.getStack(tool, modifier, newSelected);
                    if (selectedStack.m_41619_()) {
                        player.m_5661_((Component)Component.m_237110_((String)EMPTY, (Object[])new Object[]{newSelected + 1}), true);
                    } else {
                        player.m_5661_((Component)Component.m_237110_((String)SELECTED, (Object[])new Object[]{selectedStack.m_41786_(), newSelected + 1}), true);
                    }
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    static {
        LOADER = new SingletonRecordLoadable<TrickQuiverModule>(INSTANCE);
        DEFAULT_HOOKS = HookProvider.defaultHooks(ModifierHooks.BOW_AMMO, ModifierHooks.GENERAL_INTERACT);
        SELECTED_SLOT = TConstruct.getResource("trick_quiver_selected");
        DISABLED = TConstruct.makeTranslation("modifier", "trick_quiver.disabled");
        EMPTY = TConstruct.makeTranslationKey("modifier", "trick_quiver.empty");
        SELECTED = TConstruct.makeTranslationKey("modifier", "trick_quiver.selected");
    }
}

