/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.client.screen;

import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.level.block.state.properties.Property;
import slimeknights.mantle.client.screen.ElementScreen;
import slimeknights.mantle.client.screen.MultiModuleScreen;
import slimeknights.mantle.inventory.MultiModuleContainerMenu;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.GuiUtil;
import slimeknights.tconstruct.smeltery.block.controller.ControllerBlock;
import slimeknights.tconstruct.smeltery.block.entity.controller.HeatingStructureBlockEntity;
import slimeknights.tconstruct.smeltery.block.entity.module.FuelModule;
import slimeknights.tconstruct.smeltery.client.screen.IScreenWithFluidTank;
import slimeknights.tconstruct.smeltery.client.screen.module.GuiFuelModule;
import slimeknights.tconstruct.smeltery.client.screen.module.GuiMeltingModule;
import slimeknights.tconstruct.smeltery.client.screen.module.GuiSmelteryTank;
import slimeknights.tconstruct.smeltery.client.screen.module.HeatingStructureSideInventoryScreen;
import slimeknights.tconstruct.smeltery.menu.HeatingStructureContainerMenu;

public class HeatingStructureScreen
extends MultiModuleScreen<HeatingStructureContainerMenu>
implements IScreenWithFluidTank {
    public static final ResourceLocation BACKGROUND = TConstruct.getResource("textures/gui/smeltery.png");
    private static final ElementScreen SCALA = new ElementScreen(BACKGROUND, 176, 76, 52, 52, 256, 256);
    private final HeatingStructureSideInventoryScreen sideInventory;
    private final HeatingStructureBlockEntity te;
    private final GuiSmelteryTank tank;
    public final GuiMeltingModule melting;
    private final GuiFuelModule fuel;

    public HeatingStructureScreen(HeatingStructureContainerMenu container, Inventory playerInventory, Component title) {
        super((MultiModuleContainerMenu)container, playerInventory, title);
        HeatingStructureBlockEntity te = (HeatingStructureBlockEntity)container.getTile();
        if (te != null) {
            this.te = te;
            this.tank = new GuiSmelteryTank((AbstractContainerScreen<?>)this, te.getTank(), 8, 16, HeatingStructureScreen.SCALA.w, HeatingStructureScreen.SCALA.h, Objects.requireNonNull(BuiltInRegistries.f_257049_.m_7981_((Object)te.m_58903_())));
            int slots = te.getMeltingInventory().getSlots();
            this.sideInventory = new HeatingStructureSideInventoryScreen(this, container.getSideInventory(), playerInventory, slots, HeatingStructureContainerMenu.calcColumns(slots));
            this.addModule(this.sideInventory);
            FuelModule fuelModule = te.getFuelModule();
            this.melting = new GuiMeltingModule((AbstractContainerScreen<?>)this, te.getMeltingInventory(), fuelModule::getTemperature, this.sideInventory::shouldDrawSlot, BACKGROUND);
            this.fuel = new GuiFuelModule((AbstractContainerScreen<?>)this, fuelModule, 71, 32, 12, 36, 70, 15, false, BACKGROUND);
        } else {
            this.te = null;
            this.tank = null;
            this.melting = null;
            this.fuel = null;
            this.sideInventory = null;
        }
    }

    protected void m_181908_() {
        super.m_181908_();
        if (this.te == null || !((Boolean)this.te.m_58900_().m_61143_((Property)ControllerBlock.IN_STRUCTURE)).booleanValue() || this.te.getMeltingInventory().getSlots() != this.sideInventory.getSlotCount()) {
            this.m_7379_();
        }
    }

    protected void m_7286_(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        GuiUtil.drawBackground(graphics, this, BACKGROUND);
        if (this.fuel != null) {
            this.fuel.draw(graphics);
        }
        super.m_7286_(graphics, partialTicks, mouseX, mouseY);
        if (this.tank != null) {
            this.tank.renderFluids(graphics.m_280168_());
        }
    }

    protected void m_280003_(GuiGraphics graphics, int mouseX, int mouseY) {
        super.m_280003_(graphics, mouseX, mouseY);
        assert (this.f_96541_ != null);
        SCALA.draw(graphics, 8, 16);
        if (this.tank != null) {
            this.tank.renderHighlight(graphics, mouseX, mouseY);
        }
        if (this.fuel != null) {
            this.fuel.renderHighlight(graphics, mouseX - this.f_97735_, mouseY - this.f_97736_);
        }
        if (this.melting != null) {
            this.melting.drawHeatBars(graphics);
        }
    }

    protected void m_280072_(GuiGraphics graphics, int mouseX, int mouseY) {
        super.m_280072_(graphics, mouseX, mouseY);
        if (this.tank != null) {
            this.tank.drawTooltip(graphics, mouseX, mouseY);
        }
        if (this.fuel != null) {
            boolean hasTank = false;
            if (this.te.getStructure() != null) {
                hasTank = this.te.getStructure().hasTanks();
            }
            this.fuel.addTooltip(graphics, mouseX, mouseY, hasTank);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        if (mouseButton == 0 && this.tank != null) {
            this.tank.handleClick((int)mouseX - this.cornerX, (int)mouseY - this.cornerY);
        }
        return super.m_6375_(mouseX, mouseY, mouseButton);
    }

    @Override
    public IScreenWithFluidTank.FluidLocation getFluidUnderMouse(int mouseX, int mouseY) {
        IScreenWithFluidTank.FluidLocation ingredient;
        int checkX = mouseX - this.cornerX;
        int checkY = mouseY - this.cornerY;
        if (this.fuel != null && (ingredient = this.fuel.getFluidUnderMouse(checkX, checkY)) != null) {
            return ingredient;
        }
        if (this.tank != null) {
            return this.tank.getFluidUnderMouse(checkX, checkY);
        }
        return null;
    }
}

