/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.data.material;

import com.google.gson.JsonObject;
import com.mojang.blaze3d.platform.NativeImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraftforge.common.data.ExistingFileHelper;
import slimeknights.tconstruct.library.client.data.GenericTextureGenerator;
import slimeknights.tconstruct.library.client.data.material.AbstractMaterialSpriteProvider;
import slimeknights.tconstruct.library.client.data.material.AbstractPartSpriteProvider;
import slimeknights.tconstruct.library.client.data.material.GeneratorPartTextureJsonGenerator;
import slimeknights.tconstruct.library.client.data.spritetransformer.ISpriteTransformer;
import slimeknights.tconstruct.library.client.data.util.AbstractSpriteReader;
import slimeknights.tconstruct.library.client.data.util.DataGenSpriteReader;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;

public class MaterialPartTextureGenerator
extends GenericTextureGenerator {
    public static final String FOLDER = "textures";
    private final DataGenSpriteReader spriteReader;
    private final ExistingFileHelper existingFileHelper;
    private final AbstractPartSpriteProvider partProvider;
    private final AbstractMaterialSpriteProvider[] materialProviders;
    private final GeneratorPartTextureJsonGenerator.StatOverride overrides;
    private static final List<IPartTextureCallback> TEXTURE_CALLBACKS = new ArrayList<IPartTextureCallback>();

    public MaterialPartTextureGenerator(PackOutput packOutput, ExistingFileHelper existingFileHelper, AbstractPartSpriteProvider spriteProvider, AbstractMaterialSpriteProvider ... materialProviders) {
        this(packOutput, existingFileHelper, spriteProvider, GeneratorPartTextureJsonGenerator.StatOverride.EMPTY, materialProviders);
    }

    public MaterialPartTextureGenerator(PackOutput packOutput, ExistingFileHelper existingFileHelper, AbstractPartSpriteProvider spriteProvider, GeneratorPartTextureJsonGenerator.StatOverride overrides, AbstractMaterialSpriteProvider ... materialProviders) {
        super(packOutput, FOLDER);
        this.spriteReader = new DataGenSpriteReader(existingFileHelper, FOLDER);
        this.existingFileHelper = existingFileHelper;
        this.partProvider = spriteProvider;
        this.overrides = overrides;
        this.materialProviders = materialProviders;
    }

    public String m_6055_() {
        StringBuilder name = new StringBuilder();
        name.append("Material Part Generator - ");
        name.append(this.partProvider.getName());
        name.append(" - ");
        name.append(this.materialProviders[0].getName());
        for (int i = 1; i < this.materialProviders.length; ++i) {
            name.append(", ").append(this.materialProviders[i].getName());
        }
        return name.toString();
    }

    public CompletableFuture<?> m_213708_(CachedOutput cache) {
        MaterialPartTextureGenerator.runCallbacks(this.existingFileHelper, null);
        List<AbstractPartSpriteProvider.PartSpriteInfo> parts = this.partProvider.getSprites();
        if (parts.isEmpty()) {
            throw new IllegalStateException(this.partProvider.getName() + " has no parts, must have at least one part to generate");
        }
        ArrayList tasks = new ArrayList();
        BiConsumer<ResourceLocation, NativeImage> saver = (path, image) -> tasks.add(this.saveImage(cache, (ResourceLocation)path, (NativeImage)image));
        BiConsumer<ResourceLocation, JsonObject> metaSaver = (path, meta) -> tasks.add(this.saveMetadata(cache, (ResourceLocation)path, (JsonObject)meta));
        for (AbstractMaterialSpriteProvider materialProvider : this.materialProviders) {
            Collection<AbstractMaterialSpriteProvider.MaterialSpriteInfo> materials = materialProvider.getMaterials().values();
            if (materials.isEmpty()) {
                throw new IllegalStateException(materialProvider.getName() + " has no materials, must have at least one material to generate");
            }
            for (AbstractMaterialSpriteProvider.MaterialSpriteInfo material : materials) {
                block2: for (AbstractPartSpriteProvider.PartSpriteInfo part : parts) {
                    for (MaterialStatsId statType : part.getStatTypes()) {
                        if (!material.supportStatType(statType) && !this.overrides.hasOverride(statType, material.getTexture())) continue;
                        ResourceLocation spritePath = MaterialPartTextureGenerator.outputPath(part, material);
                        if (this.spriteReader.exists(spritePath)) continue block2;
                        MaterialPartTextureGenerator.generateSprite(this.spriteReader, material, part, spritePath, saver, metaSaver);
                        continue block2;
                    }
                }
            }
        }
        return MaterialPartTextureGenerator.allOf(tasks).thenRunAsync(() -> {
            this.spriteReader.closeAll();
            this.partProvider.cleanCache();
            MaterialPartTextureGenerator.runCallbacks(null, null);
        });
    }

    public static ResourceLocation outputPath(AbstractPartSpriteProvider.PartSpriteInfo part, AbstractMaterialSpriteProvider.MaterialSpriteInfo material) {
        ResourceLocation materialTexture = material.getTexture();
        return part.getPath().m_266382_("_" + materialTexture.m_135827_() + "_" + materialTexture.m_135815_());
    }

    public static void generateSprite(AbstractSpriteReader spriteReader, AbstractMaterialSpriteProvider.MaterialSpriteInfo material, AbstractPartSpriteProvider.PartSpriteInfo part, ResourceLocation spritePath, BiConsumer<ResourceLocation, NativeImage> saver, BiConsumer<ResourceLocation, JsonObject> metaSaver) {
        JsonObject meta;
        String fallback;
        NativeImage base = null;
        String[] stringArray = material.getFallbacks();
        int n = stringArray.length;
        for (int i = 0; i < n && (base = part.getTexture(spriteReader, fallback = stringArray[i])) == null; ++i) {
        }
        if (base == null) {
            base = part.getTexture(spriteReader, "");
        }
        if (base == null) {
            throw new IllegalStateException("Missing sprite at " + part.getPath() + ".png, cannot generate textures");
        }
        ISpriteTransformer transformer = material.getTransformer();
        NativeImage transformed = transformer.transformCopy(base, part.isAllowAnimated());
        spriteReader.track(transformed);
        saver.accept(spritePath, transformed);
        if (part.isAllowAnimated() && (meta = transformer.animationMeta(base)) != null) {
            metaSaver.accept(spritePath, meta);
        }
    }

    public static void registerCallback(IPartTextureCallback callback) {
        TEXTURE_CALLBACKS.add(callback);
    }

    public static void runCallbacks(@Nullable ExistingFileHelper existingFileHelper, @Nullable ResourceManager manager) {
        for (IPartTextureCallback callback : TEXTURE_CALLBACKS) {
            callback.accept(existingFileHelper, manager);
        }
    }

    public static interface IPartTextureCallback {
        public void accept(@Nullable ExistingFileHelper var1, @Nullable ResourceManager var2);
    }
}

