/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world.block;

import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.tags.TagKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.MapColor;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.shared.block.SlimeType;

public enum FoliageType implements StringRepresentable
{
    EARTH(9230210, Tiers.STONE, MapColor.f_283824_, false),
    SKY(62682, Tiers.GOLD, MapColor.f_283821_, false),
    ICHOR(13670400, Tiers.IRON, MapColor.f_283750_, true),
    ENDER(11087359, Tiers.DIAMOND, MapColor.f_283889_, false),
    BLOOD(0xB80000, Tiers.WOOD, MapColor.f_283913_, true);

    public static final FoliageType[] VISIBLE;
    public static final FoliageType[] OVERWORLD;
    public static final FoliageType[] NETHER;
    private final int color;
    private final Tiers harvestTier;
    private final MapColor mapColor;
    private final boolean nether;
    private final String serializedName = this.name().toLowerCase(Locale.ROOT);
    private final TagKey<Block> grassBlockTag;
    private SlimeType slimeType;

    private FoliageType(int color, Tiers harvestTier, MapColor mapColor, boolean nether) {
        this.color = color;
        this.harvestTier = harvestTier;
        this.mapColor = mapColor;
        this.nether = nether;
        this.grassBlockTag = TinkerTags.Blocks.tag((nether ? "slimy_nylium/" : "slimy_grass/") + this.m_7912_());
    }

    @Nullable
    public SlimeType asSlime() {
        if (this.slimeType == null && this != BLOOD) {
            this.slimeType = SlimeType.values()[this.ordinal()];
        }
        return this.slimeType;
    }

    public int getColor() {
        return this.color;
    }

    public Tiers getHarvestTier() {
        return this.harvestTier;
    }

    public MapColor getMapColor() {
        return this.mapColor;
    }

    public boolean isNether() {
        return this.nether;
    }

    public TagKey<Block> getGrassBlockTag() {
        return this.grassBlockTag;
    }

    public SlimeType getSlimeType() {
        return this.slimeType;
    }

    public String m_7912_() {
        return this.serializedName;
    }

    static {
        VISIBLE = new FoliageType[]{EARTH, SKY, BLOOD, ENDER};
        OVERWORLD = new FoliageType[]{EARTH, SKY};
        NETHER = new FoliageType[]{ICHOR, BLOOD};
    }
}

