/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tables.menu;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import slimeknights.mantle.util.sync.LambdaDataSlot;
import slimeknights.tconstruct.tables.TinkerTables;
import slimeknights.tconstruct.tables.block.entity.table.ModifierWorktableBlockEntity;
import slimeknights.tconstruct.tables.menu.TabbedContainerMenu;
import slimeknights.tconstruct.tables.menu.slot.ArmorSlot;
import slimeknights.tconstruct.tables.menu.slot.LazyResultSlot;

public class ModifierWorktableContainerMenu
extends TabbedContainerMenu<ModifierWorktableBlockEntity> {
    private final List<Slot> inputSlots;
    private final LazyResultSlot outputSlot;

    public ModifierWorktableContainerMenu(int windowIdIn, Inventory inv, @Nullable ModifierWorktableBlockEntity tile) {
        super((MenuType)TinkerTables.modifierWorktableContainer.get(), windowIdIn, inv, tile);
        if (tile != null) {
            this.outputSlot = new LazyResultSlot(tile.getCraftingResult(), 125, 33);
            this.m_38897_(this.outputSlot);
            this.inputSlots = new ArrayList<Slot>();
            this.inputSlots.add(this.m_38897_(new WorktableSlot(this, tile, 0, 8, 15)));
            for (int index = 0; index < tile.m_6643_() - 1; ++index) {
                this.inputSlots.add(this.m_38897_(new WorktableSlot(this, tile, index + 1, 8, 35 + 18 * index)));
            }
            this.m_38895_((DataSlot)new LambdaDataSlot(-1, tile::getSelectedIndex, i -> {
                tile.selectModifier(i);
                this.updateScreen();
            }));
            this.updateScreen();
        } else {
            this.inputSlots = Collections.emptyList();
            this.outputSlot = null;
        }
        for (ArmorItem.Type slotType : ArmorItem.Type.values()) {
            this.m_38897_(new ArmorSlot(inv, slotType.m_266308_(), 152, 8 + slotType.ordinal() * 18));
        }
        this.m_38897_(new Slot((Container)inv, 40, 132, 62).setBackground(InventoryMenu.f_39692_, InventoryMenu.f_39697_));
        this.addChestSideInventory();
        this.addInventorySlots();
    }

    public ModifierWorktableContainerMenu(int id, Inventory inv, FriendlyByteBuf buf) {
        this(id, inv, (ModifierWorktableBlockEntity)ModifierWorktableContainerMenu.getTileEntityFromBuf((FriendlyByteBuf)buf, ModifierWorktableBlockEntity.class));
    }

    public void m_6199_(Container inventoryIn) {
    }

    public boolean m_6366_(Player playerIn, int id) {
        if (playerIn.m_5833_()) {
            return false;
        }
        if (id >= 0 && this.tile != null) {
            ((ModifierWorktableBlockEntity)this.tile).selectModifier(id);
        }
        return true;
    }

    public boolean m_5882_(ItemStack stack, Slot slotIn) {
        return slotIn != this.outputSlot && super.m_5882_(stack, slotIn);
    }

    public List<Slot> getInputSlots() {
        return this.inputSlots;
    }

    public LazyResultSlot getOutputSlot() {
        return this.outputSlot;
    }

    private static class WorktableSlot
    extends Slot {
        private final TabbedContainerMenu<?> menu;
        private final ModifierWorktableBlockEntity tile;

        public WorktableSlot(TabbedContainerMenu<?> menu, ModifierWorktableBlockEntity tile, int index, int xPosition, int yPosition) {
            super((Container)tile, index, xPosition, yPosition);
            this.menu = menu;
            this.tile = tile;
        }

        public void m_6654_() {
            this.tile.onSlotChanged(this.f_40219_);
            super.m_6654_();
            this.menu.updateScreen();
        }
    }
}

