/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tables.client.inventory;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.client.modifiers.ModifierIconManager;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.ModifierManager;
import slimeknights.tconstruct.library.recipe.partbuilder.Pattern;
import slimeknights.tconstruct.library.recipe.worktable.IModifierWorktableRecipe;
import slimeknights.tconstruct.library.tools.nbt.LazyToolStack;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.tables.block.entity.table.ModifierWorktableBlockEntity;
import slimeknights.tconstruct.tables.client.inventory.BaseTabbedScreen;
import slimeknights.tconstruct.tables.client.inventory.TinkerStationScreen;
import slimeknights.tconstruct.tables.client.inventory.module.InfoPanelScreen;
import slimeknights.tconstruct.tables.menu.ModifierWorktableContainerMenu;
import slimeknights.tconstruct.tools.item.ModifierCrystalItem;

public class ModifierWorktableScreen
extends BaseTabbedScreen<ModifierWorktableBlockEntity, ModifierWorktableContainerMenu> {
    protected static final Component TITLE = TConstruct.makeTranslation("gui", "modifier_worktable.title");
    protected static final Component TABLE_INFO = TConstruct.makeTranslation("gui", "modifier_worktable.info");
    private static final ResourceLocation BACKGROUND = TConstruct.getResource("textures/gui/modifier_worktable.png");
    private static final Pattern[] INPUT_PATTERNS = new Pattern[]{new Pattern("tconstruct", "pickaxe"), new Pattern("tconstruct", "ingot"), new Pattern("tconstruct", "quartz")};
    protected InfoPanelScreen tinkerInfo;
    protected InfoPanelScreen modifierInfo;
    private float sliderProgress = 0.0f;
    private boolean clickedOnScrollBar;
    private int modifierIndexOffset = 0;

    public ModifierWorktableScreen(ModifierWorktableContainerMenu container, Inventory playerInventory, Component title) {
        super(container, playerInventory, title);
        this.tinkerInfo = new InfoPanelScreen<ModifierWorktableScreen, ModifierWorktableContainerMenu>(this, container, playerInventory, title);
        this.tinkerInfo.setTextScale(0.8888889f);
        this.addModule(this.tinkerInfo);
        this.modifierInfo = new InfoPanelScreen<ModifierWorktableScreen, ModifierWorktableContainerMenu>(this, container, playerInventory, title);
        this.modifierInfo.setTextScale(0.7777778f);
        this.addModule(this.modifierInfo);
        this.tinkerInfo.yOffset = 0;
        this.modifierInfo.yOffset = this.tinkerInfo.f_97727_ + 4;
        this.addChestSideInventory(playerInventory);
    }

    protected void m_7286_(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        this.drawBackground(graphics, BACKGROUND);
        graphics.m_280218_(BACKGROUND, this.cornerX + 103, this.cornerY + 15 + (int)(41.0f * this.sliderProgress), 176 + (this.canScroll() ? 0 : 12), 0, 12, 15);
        this.drawModifierBackgrounds(graphics, mouseX, mouseY, this.cornerX + 28, this.cornerY + 15);
        List<Slot> slots = ((ModifierWorktableContainerMenu)this.getMenu()).getInputSlots();
        int max = Math.min(slots.size(), INPUT_PATTERNS.length);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.f_39692_);
        for (int i = 0; i < max; ++i) {
            this.drawIconEmpty(graphics, slots.get(i), INPUT_PATTERNS[i]);
        }
        this.drawModifierIcons(graphics, this.cornerX + 28, this.cornerY + 15);
        super.m_7286_(graphics, partialTicks, mouseX, mouseY);
    }

    private int getButtonAt(int mouseX, int mouseY) {
        List<ModifierEntry> buttons;
        if (this.tile != null && !(buttons = ((ModifierWorktableBlockEntity)this.tile).getCurrentButtons()).isEmpty()) {
            int x = this.cornerX + 28;
            int y = this.cornerY + 15;
            int maxIndex = Math.min(this.modifierIndexOffset + 12, buttons.size());
            for (int l = this.modifierIndexOffset; l < maxIndex; ++l) {
                int relative = l - this.modifierIndexOffset;
                double buttonX = (double)mouseX - (double)(x + relative % 4 * 18);
                double buttonY = (double)mouseY - (double)(y + relative / 4 * 18);
                if (!(buttonX >= 0.0) || !(buttonY >= 0.0) || !(buttonX < 18.0) || !(buttonY < 18.0)) continue;
                return l;
            }
        }
        return -1;
    }

    protected void m_280072_(GuiGraphics graphics, int mouseX, int mouseY) {
        int index;
        List<ModifierEntry> buttons;
        super.m_280072_(graphics, mouseX, mouseY);
        if (this.tile != null && !(buttons = ((ModifierWorktableBlockEntity)this.tile).getCurrentButtons()).isEmpty() && (index = this.getButtonAt(mouseX, mouseY)) >= 0) {
            graphics.m_280557_(this.f_96547_, buttons.get(index).getDisplayName(), mouseX, mouseY);
        }
    }

    private void drawModifierBackgrounds(GuiGraphics graphics, int mouseX, int mouseY, int left, int top) {
        if (this.tile != null) {
            int selectedIndex = ((ModifierWorktableBlockEntity)this.tile).getSelectedIndex();
            int max = Math.min(this.modifierIndexOffset + 12, this.getPartRecipeCount());
            for (int i = this.modifierIndexOffset; i < max; ++i) {
                int relative = i - this.modifierIndexOffset;
                int x = left + relative % 4 * 18;
                int y = top + relative / 4 * 18;
                int u = this.f_97727_;
                if (i == selectedIndex) {
                    u += 18;
                } else if (mouseX >= x && mouseY >= y && mouseX < x + 18 && mouseY < y + 18) {
                    u += 36;
                }
                graphics.m_280218_(BACKGROUND, x, y, 0, u, 18, 18);
            }
        }
    }

    private void drawModifierIcons(GuiGraphics graphics, int left, int top) {
        if (this.tile != null) {
            assert (this.f_96541_ != null);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.f_39692_);
            List<ModifierEntry> list = ((ModifierWorktableBlockEntity)this.tile).getCurrentButtons();
            int max = Math.min(this.modifierIndexOffset + 12, this.getPartRecipeCount());
            for (int i = this.modifierIndexOffset; i < max; ++i) {
                int relative = i - this.modifierIndexOffset;
                int x = left + relative % 4 * 18 + 1;
                int y = top + relative / 4 * 18 + 1;
                ModifierIconManager.renderIcon(graphics, list.get(i).getModifier(), x, y, 100, 16);
            }
        }
    }

    @Override
    public void updateDisplay() {
        if (!this.canScroll()) {
            this.sliderProgress = 0.0f;
            this.modifierIndexOffset = 0;
        }
        if (this.tile != null) {
            Component message = ((ModifierWorktableBlockEntity)this.tile).getCurrentMessage();
            if (!message.getString().isEmpty()) {
                this.message(message);
                return;
            }
            LazyToolStack lazyResult = ((ModifierWorktableBlockEntity)this.tile).getResult();
            if (lazyResult == null) {
                this.message(TABLE_INFO);
                return;
            }
            ToolStack result = lazyResult.getTool();
            ItemStack resultStack = lazyResult.getStack();
            TinkerStationScreen.updateToolPanel(this.tinkerInfo, result, resultStack);
            this.modifierInfo.setCaption((Component)Component.m_237119_());
            this.modifierInfo.setText(new Component[]{Component.m_237119_()});
            if (result.hasTag(TinkerTags.Items.MODIFIABLE)) {
                TinkerStationScreen.updateModifierPanel(this.modifierInfo, result);
            } else {
                ModifierId modifierId = ModifierCrystalItem.getModifier(resultStack);
                if (modifierId != null) {
                    Modifier modifier = ModifierManager.getValue(modifierId);
                    this.modifierInfo.setCaption((Component)TConstruct.makeTranslation("gui", "tinker_station.modifiers"));
                    this.modifierInfo.setText(Collections.singletonList(modifier.getDisplayName()), Collections.singletonList(modifier.getDescription()));
                }
            }
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        this.clickedOnScrollBar = false;
        if (this.tinkerInfo.handleMouseClicked(mouseX, mouseY, mouseButton) || this.modifierInfo.handleMouseClicked(mouseX, mouseY, mouseButton)) {
            return false;
        }
        if (this.tile != null && !((ModifierWorktableBlockEntity)this.tile).getCurrentButtons().isEmpty()) {
            int index = this.getButtonAt((int)mouseX, (int)mouseY);
            assert (this.f_96541_ != null && this.f_96541_.f_91074_ != null);
            if (index >= 0 && ((ModifierWorktableContainerMenu)this.getMenu()).m_6366_((Player)this.f_96541_.f_91074_, index)) {
                this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12495_, (float)1.0f));
                assert (this.f_96541_.f_91072_ != null);
                this.f_96541_.f_91072_.m_105208_(((ModifierWorktableContainerMenu)this.getMenu()).f_38840_, index);
                return true;
            }
            int x = this.cornerX + 103;
            int y = this.cornerY + 15;
            if (mouseX >= (double)x && mouseX < (double)(x + 12) && mouseY >= (double)y && mouseY < (double)(y + 54)) {
                this.clickedOnScrollBar = true;
            }
        }
        return super.m_6375_(mouseX, mouseY, mouseButton);
    }

    public boolean m_7979_(double mouseX, double mouseY, int clickedMouseButton, double timeSinceLastClick, double unknown) {
        if (this.tinkerInfo.handleMouseClickMove(mouseX, mouseY, clickedMouseButton, timeSinceLastClick) || this.modifierInfo.handleMouseClickMove(mouseX, mouseY, clickedMouseButton, timeSinceLastClick)) {
            return false;
        }
        if (this.clickedOnScrollBar && this.canScroll()) {
            int i = this.cornerY + 14;
            int j = i + 54;
            this.sliderProgress = ((float)mouseY - (float)i - 7.5f) / ((float)(j - i) - 15.0f);
            this.sliderProgress = Mth.m_14036_((float)this.sliderProgress, (float)0.0f, (float)1.0f);
            this.modifierIndexOffset = (int)((double)(this.sliderProgress * (float)this.getHiddenRows()) + 0.5) * 4;
            return true;
        }
        return super.m_7979_(mouseX, mouseY, clickedMouseButton, timeSinceLastClick, unknown);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.tinkerInfo.handleMouseScrolled(mouseX, mouseY, delta) || this.modifierInfo.handleMouseScrolled(mouseX, mouseY, delta)) {
            return false;
        }
        if (super.m_6050_(mouseX, mouseY, delta)) {
            return true;
        }
        if (this.canScroll()) {
            int i = this.getHiddenRows();
            this.sliderProgress = Mth.m_14036_((float)((float)((double)this.sliderProgress - delta / (double)i)), (float)0.0f, (float)1.0f);
            this.modifierIndexOffset = (int)(this.sliderProgress * (float)i + 0.5f) * 4;
            return true;
        }
        return false;
    }

    public boolean m_6348_(double mouseX, double mouseY, int state) {
        if (this.tinkerInfo.handleMouseReleased(mouseX, mouseY, state) || this.modifierInfo.handleMouseReleased(mouseX, mouseY, state)) {
            return false;
        }
        return super.m_6348_(mouseX, mouseY, state);
    }

    @Override
    public void error(Component message) {
        this.tinkerInfo.setCaption(COMPONENT_ERROR);
        this.tinkerInfo.setText(message);
        this.modifierInfo.setCaption((Component)Component.m_237119_());
        this.modifierInfo.setText(new Component[]{Component.m_237119_()});
    }

    @Override
    public void warning(Component message) {
        this.tinkerInfo.setCaption(COMPONENT_WARNING);
        this.tinkerInfo.setText(message);
        this.modifierInfo.setCaption((Component)Component.m_237119_());
        this.modifierInfo.setText(new Component[]{Component.m_237119_()});
    }

    private Component getInfoTitle() {
        IModifierWorktableRecipe recipe;
        if (this.tile != null && (recipe = ((ModifierWorktableBlockEntity)this.tile).getCurrentRecipe()) != null) {
            return recipe.getTitle();
        }
        return TITLE;
    }

    public void message(Component message) {
        this.tinkerInfo.setCaption(this.getInfoTitle());
        this.tinkerInfo.setText(message);
        this.modifierInfo.setCaption((Component)Component.m_237119_());
        this.modifierInfo.setText(new Component[]{Component.m_237119_()});
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (TinkerStationScreen.needsDisplayUpdate(keyCode)) {
            this.updateDisplay();
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        if (TinkerStationScreen.needsDisplayUpdate(keyCode)) {
            this.updateDisplay();
        }
        return super.m_7920_(keyCode, scanCode, modifiers);
    }

    private int getPartRecipeCount() {
        return this.tile == null ? 0 : ((ModifierWorktableBlockEntity)this.tile).getCurrentButtons().size();
    }

    private boolean canScroll() {
        return this.getPartRecipeCount() > 12;
    }

    private int getHiddenRows() {
        return (this.getPartRecipeCount() + 4 - 1) / 4 - 3;
    }
}

