/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.shared.command.subcommand;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.shared.command.HeldModifiableItemIterator;
import slimeknights.tconstruct.shared.command.argument.SlotTypeArgument;

public class SlotsCommand {
    private static final String ADD_SUCCESS = TConstruct.makeTranslationKey("command", "slots.success.add.single");
    private static final String ADD_SUCCESS_MULTIPLE = TConstruct.makeTranslationKey("command", "slots.success.add.multiple");
    private static final String SET_SUCCESS = TConstruct.makeTranslationKey("command", "slots.success.set.single");
    private static final String SET_SUCCESS_MULTIPLE = TConstruct.makeTranslationKey("command", "slots.success.set.multiple");
    private static final SimpleCommandExceptionType INVALID_SLOT_COUNT = new SimpleCommandExceptionType((Message)TConstruct.makeTranslation("command", "slots.failure.invalid_count"));
    private static final DynamicCommandExceptionType VALIDATION_ERROR = new DynamicCommandExceptionType(error -> (Component)error);

    public static void register(LiteralArgumentBuilder<CommandSourceStack> subCommand) {
        ((LiteralArgumentBuilder)subCommand.requires(sender -> sender.m_6761_(2))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91460_()).then(Commands.m_82127_((String)"add").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"slot_type", (ArgumentType)SlotTypeArgument.slotType(false)).executes(context -> SlotsCommand.run((CommandContext<CommandSourceStack>)context, Operation.ADD, 1))).then(Commands.m_82129_((String)"count", (ArgumentType)IntegerArgumentType.integer()).executes(context -> SlotsCommand.run((CommandContext<CommandSourceStack>)context, Operation.ADD)))))).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"slot_type", (ArgumentType)SlotTypeArgument.slotType(false)).then(Commands.m_82129_((String)"count", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> SlotsCommand.run((CommandContext<CommandSourceStack>)context, Operation.SET))))));
    }

    private static int run(CommandContext<CommandSourceStack> context, Operation op) throws CommandSyntaxException {
        return SlotsCommand.run(context, op, IntegerArgumentType.getInteger(context, (String)"count"));
    }

    private static int run(CommandContext<CommandSourceStack> context, Operation op, int count) throws CommandSyntaxException {
        if (count == 0 && op != Operation.SET) {
            throw INVALID_SLOT_COUNT.create();
        }
        SlotType slotType = SlotTypeArgument.getSlotType(context, "slot_type");
        List<LivingEntity> successes = HeldModifiableItemIterator.apply(context, (living, stack) -> {
            ToolStack tool = ToolStack.copyFrom(stack);
            ModDataNBT slots = tool.getPersistentData();
            if (op == Operation.ADD) {
                slots.addSlots(slotType, count);
            } else {
                slots.addSlots(slotType, count - tool.getFreeSlots(slotType));
            }
            tool.rebuildStats();
            Component toolValidation = tool.tryValidate();
            if (toolValidation != null) {
                throw VALIDATION_ERROR.create((Object)toolValidation);
            }
            living.m_21008_(InteractionHand.MAIN_HAND, tool.createStack(stack.m_41613_()));
            return true;
        });
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        int size = successes.size();
        if (op == Operation.ADD) {
            if (size == 1) {
                source.m_288197_(() -> Component.m_237110_((String)ADD_SUCCESS, (Object[])new Object[]{count, slotType.getDisplayName(), ((LivingEntity)successes.get(0)).m_5446_()}), true);
            } else {
                source.m_288197_(() -> Component.m_237110_((String)ADD_SUCCESS_MULTIPLE, (Object[])new Object[]{count, slotType.getDisplayName(), size}), true);
            }
        } else if (size == 1) {
            source.m_288197_(() -> Component.m_237110_((String)SET_SUCCESS, (Object[])new Object[]{slotType.getDisplayName(), count, ((LivingEntity)successes.get(0)).m_5446_()}), true);
        } else {
            source.m_288197_(() -> Component.m_237110_((String)SET_SUCCESS_MULTIPLE, (Object[])new Object[]{slotType.getDisplayName(), count, size}), true);
        }
        return size;
    }

    private static enum Operation {
        ADD,
        SET;

    }
}

