/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.plugin.jei;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.runtime.IClickableIngredient;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import slimeknights.mantle.recipe.helper.RecipeHelper;
import slimeknights.mantle.util.RegistryHelper;
import slimeknights.mantle.util.RetexturedHelper;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.fluids.TinkerFluids;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.recipe.TinkerRecipeTypes;
import slimeknights.tconstruct.library.recipe.alloying.AlloyRecipe;
import slimeknights.tconstruct.library.recipe.casting.IDisplayableCastingRecipe;
import slimeknights.tconstruct.library.recipe.entitymelting.EntityMeltingRecipe;
import slimeknights.tconstruct.library.recipe.fuel.MeltingFuel;
import slimeknights.tconstruct.library.recipe.material.MaterialRecipe;
import slimeknights.tconstruct.library.recipe.melting.MeltingRecipe;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierRecipeLookup;
import slimeknights.tconstruct.library.recipe.modifiers.adding.IDisplayModifierRecipe;
import slimeknights.tconstruct.library.recipe.modifiers.severing.SeveringRecipe;
import slimeknights.tconstruct.library.recipe.molding.MoldingRecipe;
import slimeknights.tconstruct.library.recipe.partbuilder.IDisplayPartBuilderRecipe;
import slimeknights.tconstruct.library.recipe.tinkerstation.building.ToolBuildingRecipe;
import slimeknights.tconstruct.library.recipe.worktable.IModifierWorktableRecipe;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.definition.module.build.ToolTraitHook;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.library.tools.item.IModifiableDisplay;
import slimeknights.tconstruct.library.tools.layout.StationSlotLayoutLoader;
import slimeknights.tconstruct.library.tools.nbt.MaterialIdNBT;
import slimeknights.tconstruct.library.tools.nbt.MaterialNBT;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;
import slimeknights.tconstruct.library.tools.part.IMaterialItem;
import slimeknights.tconstruct.plugin.jei.AlloyRecipeCategory;
import slimeknights.tconstruct.plugin.jei.MoldingRecipeCategory;
import slimeknights.tconstruct.plugin.jei.TConstructJEIConstants;
import slimeknights.tconstruct.plugin.jei.ToolBuildingCategory;
import slimeknights.tconstruct.plugin.jei.casting.CastingBasinCategory;
import slimeknights.tconstruct.plugin.jei.casting.CastingTableCategory;
import slimeknights.tconstruct.plugin.jei.entity.DefaultEntityMeltingRecipe;
import slimeknights.tconstruct.plugin.jei.entity.EntityMeltingRecipeCategory;
import slimeknights.tconstruct.plugin.jei.entity.SeveringCategory;
import slimeknights.tconstruct.plugin.jei.melting.FoundryCategory;
import slimeknights.tconstruct.plugin.jei.melting.MeltingCategory;
import slimeknights.tconstruct.plugin.jei.melting.MeltingFuelHandler;
import slimeknights.tconstruct.plugin.jei.modifiers.ModifierBookmarkIngredientRenderer;
import slimeknights.tconstruct.plugin.jei.modifiers.ModifierIngredientHelper;
import slimeknights.tconstruct.plugin.jei.modifiers.ModifierRecipeCategory;
import slimeknights.tconstruct.plugin.jei.modifiers.ModifierWorktableCategory;
import slimeknights.tconstruct.plugin.jei.partbuilder.MaterialItemList;
import slimeknights.tconstruct.plugin.jei.partbuilder.PartBuilderCategory;
import slimeknights.tconstruct.plugin.jei.partbuilder.PatternIngredientHelper;
import slimeknights.tconstruct.plugin.jei.partbuilder.PatternIngredientRenderer;
import slimeknights.tconstruct.plugin.jei.transfer.CraftingStationTransferInfo;
import slimeknights.tconstruct.plugin.jei.transfer.TinkerStationTransferInfo;
import slimeknights.tconstruct.plugin.jei.util.ClickableIngredient;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.block.component.SearedTankBlock;
import slimeknights.tconstruct.smeltery.client.screen.HeatingStructureScreen;
import slimeknights.tconstruct.smeltery.client.screen.IScreenWithFluidTank;
import slimeknights.tconstruct.smeltery.client.screen.MelterScreen;
import slimeknights.tconstruct.smeltery.data.SmelteryCompat;
import slimeknights.tconstruct.smeltery.item.CopperCanItem;
import slimeknights.tconstruct.smeltery.item.TankItem;
import slimeknights.tconstruct.tables.TinkerTables;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.item.CreativeSlotItem;
import slimeknights.tconstruct.tools.item.ModifierCrystalItem;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    public static IModIdHelper modIdHelper;

    public ResourceLocation getPluginUid() {
        return TConstructJEIConstants.PLUGIN;
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        IGuiHelper guiHelper = registry.getJeiHelpers().getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new CastingBasinCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new CastingTableCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new MoldingRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new MeltingCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new AlloyRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new EntityMeltingRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new FoundryCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new ModifierRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new SeveringCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new ToolBuildingCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new PartBuilderCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new ModifierWorktableCategory(guiHelper)});
    }

    public void registerIngredients(IModIngredientRegistration registration) {
        assert (Minecraft.m_91087_().f_91073_ != null);
        RecipeManager manager = Minecraft.m_91087_().f_91073_.m_7465_();
        List<Object> modifiers = Collections.emptyList();
        if (((Boolean)Config.CLIENT.showModifiersInJEI.get()).booleanValue()) {
            modifiers = ModifierRecipeLookup.getRecipeModifierList();
        }
        registration.register(TConstructJEIConstants.MODIFIER_TYPE, modifiers, (IIngredientHelper)new ModifierIngredientHelper(), (IIngredientRenderer)ModifierBookmarkIngredientRenderer.INSTANCE);
        registration.register(TConstructJEIConstants.PATTERN_TYPE, Collections.emptyList(), (IIngredientHelper)new PatternIngredientHelper(), (IIngredientRenderer)PatternIngredientRenderer.INSTANCE);
    }

    public void registerRecipes(IRecipeRegistration register) {
        assert (Minecraft.m_91087_().f_91073_ != null);
        RecipeManager manager = Minecraft.m_91087_().f_91073_.m_7465_();
        List castingBasinRecipes = RecipeHelper.getJEIRecipes((RecipeManager)manager, (net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)TinkerRecipeTypes.CASTING_BASIN.get()), IDisplayableCastingRecipe.class);
        register.addRecipes(TConstructJEIConstants.CASTING_BASIN, castingBasinRecipes);
        List castingTableRecipes = RecipeHelper.getJEIRecipes((RecipeManager)manager, (net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)TinkerRecipeTypes.CASTING_TABLE.get()), IDisplayableCastingRecipe.class);
        register.addRecipes(TConstructJEIConstants.CASTING_TABLE, castingTableRecipes);
        List meltingRecipes = RecipeHelper.getJEIRecipes((RecipeManager)manager, (net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)TinkerRecipeTypes.MELTING.get()), MeltingRecipe.class);
        register.addRecipes(TConstructJEIConstants.MELTING, meltingRecipes);
        register.addRecipes(TConstructJEIConstants.FOUNDRY, meltingRecipes);
        MeltingFuelHandler.setMeltngFuels(RecipeHelper.getRecipes((RecipeManager)manager, (net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)TinkerRecipeTypes.FUEL.get()), MeltingFuel.class));
        List entityMeltingRecipes = RecipeHelper.getJEIRecipes((RecipeManager)manager, (net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)TinkerRecipeTypes.ENTITY_MELTING.get()), EntityMeltingRecipe.class);
        entityMeltingRecipes.add(new DefaultEntityMeltingRecipe(entityMeltingRecipes));
        register.addRecipes(TConstructJEIConstants.ENTITY_MELTING, entityMeltingRecipes);
        List alloyRecipes = RecipeHelper.getJEIRecipes((RecipeManager)manager, (net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)TinkerRecipeTypes.ALLOYING.get()), AlloyRecipe.class);
        register.addRecipes(TConstructJEIConstants.ALLOY, alloyRecipes);
        ImmutableList moldingRecipes = ImmutableList.builder().addAll((Iterable)RecipeHelper.getJEIRecipes((RecipeManager)manager, (net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)TinkerRecipeTypes.MOLDING_TABLE.get()), MoldingRecipe.class)).addAll((Iterable)RecipeHelper.getJEIRecipes((RecipeManager)manager, (net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)TinkerRecipeTypes.MOLDING_BASIN.get()), MoldingRecipe.class)).build();
        register.addRecipes(TConstructJEIConstants.MOLDING, (List)moldingRecipes);
        List modifierRecipes = RecipeHelper.getJEIRecipes((RecipeManager)manager, (net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)TinkerRecipeTypes.TINKER_STATION.get()), IDisplayModifierRecipe.class).stream().sorted((r1, r2) -> {
            SlotType t1 = r1.getSlotType();
            SlotType t2 = r2.getSlotType();
            String n1 = t1 == null ? "zzzzzzzzzz" : t1.getName();
            String n2 = t2 == null ? "zzzzzzzzzz" : t2.getName();
            return n1.compareTo(n2);
        }).collect(Collectors.toList());
        register.addRecipes(TConstructJEIConstants.MODIFIERS, modifierRecipes);
        List severingRecipes = RecipeHelper.getJEIRecipes((RecipeManager)manager, (net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)TinkerRecipeTypes.SEVERING.get()), SeveringRecipe.class);
        register.addRecipes(TConstructJEIConstants.SEVERING, severingRecipes);
        List<ToolBuildingRecipe> toolBuilding = RecipeHelper.getJEIRecipes((RecipeManager)manager, (net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)TinkerRecipeTypes.TINKER_STATION.get()), ToolBuildingRecipe.class).stream().sorted(Comparator.comparingInt(r -> StationSlotLayoutLoader.getInstance().get(r.getLayoutSlotId()).getSortIndex())).toList();
        register.addRecipes(TConstructJEIConstants.TOOL_BUILDING, toolBuilding);
        MaterialItemList.setRecipes(RecipeHelper.getRecipes((RecipeManager)manager, (net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)TinkerRecipeTypes.MATERIAL.get()), MaterialRecipe.class));
        register.addRecipes(TConstructJEIConstants.PART_BUILDER, RecipeHelper.getJEIRecipes((RecipeManager)manager, (net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)TinkerRecipeTypes.PART_BUILDER.get()), IDisplayPartBuilderRecipe.class));
        register.addRecipes(TConstructJEIConstants.MODIFIER_WORKTABLE, RecipeHelper.getJEIRecipes((RecipeManager)manager, (net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)TinkerRecipeTypes.MODIFIER_WORKTABLE.get()), IModifierWorktableRecipe.class));
    }

    private static <T extends Recipe<C>, C extends Container> void addCastingCatalyst(IRecipeCatalystRegistration registry, ItemLike item, RecipeType<IDisplayableCastingRecipe> ownCategory, net.minecraft.world.item.crafting.RecipeType<MoldingRecipe> type) {
        ItemStack stack = new ItemStack(item);
        registry.addRecipeCatalyst(stack, new RecipeType[]{ownCategory});
        assert (Minecraft.m_91087_().f_91073_ != null);
        if (!Minecraft.m_91087_().f_91073_.m_7465_().m_44054_(type).isEmpty()) {
            registry.addRecipeCatalyst(stack, new RecipeType[]{TConstructJEIConstants.MOLDING});
        }
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registry) {
        registry.addRecipeCatalyst(new ItemStack(TinkerTables.partBuilder), new RecipeType[]{TConstructJEIConstants.PART_BUILDER});
        registry.addRecipeCatalyst(new ItemStack(TinkerTables.tinkerStation), new RecipeType[]{TConstructJEIConstants.MODIFIERS, TConstructJEIConstants.TOOL_BUILDING});
        registry.addRecipeCatalyst(new ItemStack(TinkerTables.tinkersAnvil), new RecipeType[]{TConstructJEIConstants.MODIFIERS, TConstructJEIConstants.TOOL_BUILDING});
        registry.addRecipeCatalyst(new ItemStack(TinkerTables.scorchedAnvil), new RecipeType[]{TConstructJEIConstants.MODIFIERS, TConstructJEIConstants.TOOL_BUILDING});
        registry.addRecipeCatalyst(new ItemStack(TinkerTables.modifierWorktable), new RecipeType[]{TConstructJEIConstants.MODIFIER_WORKTABLE});
        registry.addRecipeCatalyst(new ItemStack(TinkerSmeltery.searedMelter), new RecipeType[]{TConstructJEIConstants.MELTING});
        registry.addRecipeCatalyst(new ItemStack(TinkerSmeltery.searedHeater), new RecipeType[]{RecipeTypes.FUELING});
        JEIPlugin.addCastingCatalyst(registry, TinkerSmeltery.searedTable, TConstructJEIConstants.CASTING_TABLE, (net.minecraft.world.item.crafting.RecipeType<MoldingRecipe>)((net.minecraft.world.item.crafting.RecipeType)TinkerRecipeTypes.MOLDING_TABLE.get()));
        JEIPlugin.addCastingCatalyst(registry, TinkerSmeltery.searedBasin, TConstructJEIConstants.CASTING_BASIN, (net.minecraft.world.item.crafting.RecipeType<MoldingRecipe>)((net.minecraft.world.item.crafting.RecipeType)TinkerRecipeTypes.MOLDING_BASIN.get()));
        registry.addRecipeCatalyst(new ItemStack(TinkerSmeltery.smelteryController), new RecipeType[]{TConstructJEIConstants.MELTING, TConstructJEIConstants.ALLOY, TConstructJEIConstants.ENTITY_MELTING});
        registry.addRecipeCatalyst(new ItemStack(TinkerSmeltery.scorchedAlloyer), new RecipeType[]{TConstructJEIConstants.ALLOY});
        JEIPlugin.addCastingCatalyst(registry, TinkerSmeltery.scorchedTable, TConstructJEIConstants.CASTING_TABLE, (net.minecraft.world.item.crafting.RecipeType<MoldingRecipe>)((net.minecraft.world.item.crafting.RecipeType)TinkerRecipeTypes.MOLDING_TABLE.get()));
        JEIPlugin.addCastingCatalyst(registry, TinkerSmeltery.scorchedBasin, TConstructJEIConstants.CASTING_BASIN, (net.minecraft.world.item.crafting.RecipeType<MoldingRecipe>)((net.minecraft.world.item.crafting.RecipeType)TinkerRecipeTypes.MOLDING_BASIN.get()));
        registry.addRecipeCatalyst(new ItemStack(TinkerSmeltery.foundryController), new RecipeType[]{TConstructJEIConstants.FOUNDRY});
        registry.addRecipeCatalyst(TConstructJEIConstants.MODIFIER_TYPE, (Object)new ModifierEntry(TinkerModifiers.severing, 1), new RecipeType[]{TConstructJEIConstants.SEVERING});
        registry.addRecipeCatalyst(TConstructJEIConstants.MODIFIER_TYPE, (Object)new ModifierEntry(TinkerModifiers.melting, 1), new RecipeType[]{TConstructJEIConstants.MELTING, TConstructJEIConstants.ENTITY_MELTING});
        for (Item item : Objects.requireNonNull(ForgeRegistries.ITEMS.tags()).getTag(TinkerTags.Items.MODIFIABLE)) {
            if (!(item instanceof IModifiable)) continue;
            IModifiable modifiable = (IModifiable)item;
            ModifierNBT traits = ToolTraitHook.getTraits(modifiable.getToolDefinition(), MaterialNBT.EMPTY);
            if (traits.getLevel(TinkerModifiers.severing.getId()) > 0) {
                registry.addRecipeCatalyst(IModifiableDisplay.getDisplayStack(item), new RecipeType[]{TConstructJEIConstants.SEVERING});
            }
            if (traits.getLevel(TinkerModifiers.melting.getId()) <= 0) continue;
            if (RegistryHelper.contains(TinkerTags.Items.MELEE, (Item)item)) {
                registry.addRecipeCatalyst(IModifiableDisplay.getDisplayStack(item), new RecipeType[]{TConstructJEIConstants.MELTING, TConstructJEIConstants.ENTITY_MELTING});
                continue;
            }
            registry.addRecipeCatalyst(IModifiableDisplay.getDisplayStack(item), new RecipeType[]{TConstructJEIConstants.MELTING});
        }
    }

    public void registerItemSubtypes(ISubtypeRegistration registry) {
        IIngredientSubtypeInterpreter tables = (stack, context) -> {
            if (context == UidContext.Ingredient) {
                return RetexturedHelper.getTextureName((ItemStack)stack);
            }
            return "";
        };
        registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)TinkerTables.craftingStation.m_5456_(), tables);
        registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)TinkerTables.partBuilder.m_5456_(), tables);
        registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)TinkerTables.tinkerStation.m_5456_(), tables);
        registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)TinkerTables.tinkersAnvil.m_5456_(), tables);
        registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)TinkerTables.modifierWorktable.m_5456_(), tables);
        registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)TinkerTables.scorchedAnvil.m_5456_(), tables);
        registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)TinkerSmeltery.smelteryController.m_5456_(), tables);
        registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)TinkerSmeltery.searedDrain.m_5456_(), tables);
        registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)TinkerSmeltery.searedDuct.m_5456_(), tables);
        registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)TinkerSmeltery.searedChute.m_5456_(), tables);
        registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)TinkerSmeltery.foundryController.m_5456_(), tables);
        registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)TinkerSmeltery.scorchedDrain.m_5456_(), tables);
        registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)TinkerSmeltery.scorchedDuct.m_5456_(), tables);
        registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)TinkerSmeltery.scorchedChute.m_5456_(), tables);
        registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)TinkerFluids.potion.m_5456_(), (stack, context) -> {
            if (!stack.m_41782_()) {
                return "";
            }
            Potion potionType = PotionUtils.m_43579_((ItemStack)stack);
            String potionTypeString = potionType.m_43492_("");
            StringBuilder stringBuilder = new StringBuilder(potionTypeString);
            List effects = PotionUtils.m_43547_((ItemStack)stack);
            for (MobEffectInstance effect : effects) {
                stringBuilder.append(";").append(effect);
            }
            return stringBuilder.toString();
        });
        IIngredientSubtypeInterpreter toolPartInterpreter = (stack, context) -> {
            MaterialVariantId materialId = IMaterialItem.getMaterialFromStack(stack);
            if (materialId.equals(IMaterial.UNKNOWN_ID)) {
                return "";
            }
            if (context == UidContext.Ingredient) {
                return materialId.toString();
            }
            return materialId.getId().toString();
        };
        for (Object item : BuiltInRegistries.f_257033_.m_206058_(TinkerTags.Items.TOOL_PARTS)) {
            registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)item.m_203334_()), toolPartInterpreter);
        }
        Item slimeskull = (Item)TinkerTools.slimesuit.get((Enum)ArmorItem.Type.HELMET);
        registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)slimeskull, (IIngredientSubtypeInterpreter)ToolSubtypeInterpreter.ALWAYS);
        for (Holder holder : BuiltInRegistries.f_257033_.m_206058_(TinkerTags.Items.MULTIPART_TOOL)) {
            Item item = (Item)holder.m_203334_();
            if (item == slimeskull) continue;
            registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)item, (IIngredientSubtypeInterpreter)ToolSubtypeInterpreter.INGREDIENT);
        }
        registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)TinkerSmeltery.copperCan.get()), (stack, context) -> CopperCanItem.getSubtype(stack));
        IIngredientSubtypeInterpreter tankInterpreter = (stack, context) -> TankItem.getSubtype(stack);
        for (SearedTankBlock.TankType type : SearedTankBlock.TankType.values()) {
            registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((SearedTankBlock)TinkerSmeltery.searedTank.get((Enum)type)).m_5456_(), tankInterpreter);
            registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((SearedTankBlock)TinkerSmeltery.scorchedTank.get((Enum)type)).m_5456_(), tankInterpreter);
        }
        registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)TinkerSmeltery.searedLantern.m_5456_(), tankInterpreter);
        registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)TinkerSmeltery.scorchedLantern.m_5456_(), tankInterpreter);
        registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)TinkerModifiers.creativeSlotItem.get()), (stack, context) -> {
            SlotType slotType = CreativeSlotItem.getSlot(stack);
            return slotType != null ? slotType.getName() : "";
        });
        registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)TinkerModifiers.modifierCrystal.get()), (stack, context) -> {
            ModifierId id = ModifierCrystalItem.getModifier(stack);
            return id == null ? "" : id.toString();
        });
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGenericGuiContainerHandler(MelterScreen.class, new GuiContainerTankHandler());
        registration.addGenericGuiContainerHandler(HeatingStructureScreen.class, new GuiContainerTankHandler());
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler((IRecipeTransferInfo)new CraftingStationTransferInfo());
        registration.addRecipeTransferHandler(new TinkerStationTransferInfo<IDisplayModifierRecipe>(TConstructJEIConstants.MODIFIERS));
        registration.addRecipeTransferHandler(new TinkerStationTransferInfo<ToolBuildingRecipe>(TConstructJEIConstants.TOOL_BUILDING));
    }

    private static void removeFluid(IIngredientManager manager, Fluid fluid) {
        manager.removeIngredientsAtRuntime((IIngredientType)ForgeTypes.FLUID_STACK, Collections.singleton(new FluidStack(fluid, 1000)));
    }

    private static boolean tagExists(String name) {
        Optional tag = BuiltInRegistries.f_257033_.m_203431_(TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation("forge", name)));
        return tag.isPresent() && ((HolderSet.Named)tag.get()).m_203632_() > 0;
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        IIngredientManager manager = jeiRuntime.getIngredientManager();
        ArrayList modifierCrystals = new ArrayList();
        ModifierCrystalItem.addVariants(modifierCrystals::add);
        if (!modifierCrystals.isEmpty()) {
            manager.removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, modifierCrystals);
        }
        JEIPlugin.removeFluid(manager, TinkerFluids.moltenSoulsteel.get());
        JEIPlugin.removeFluid(manager, TinkerFluids.moltenKnightslime.get());
        for (SmelteryCompat compat : SmelteryCompat.values()) {
            if (JEIPlugin.tagExists("ingots/" + compat.getName()) || !compat.getAltTag().isEmpty() && JEIPlugin.tagExists("ingots/" + compat.getAltTag())) continue;
            JEIPlugin.removeFluid(manager, compat.getFluid().get());
        }
        if (!ModList.get().isLoaded("ceramics")) {
            JEIPlugin.removeFluid(manager, TinkerFluids.moltenPorcelain.get());
        }
        modIdHelper = jeiRuntime.getJeiHelpers().getModIdHelper();
    }

    public static enum ToolSubtypeInterpreter implements IIngredientSubtypeInterpreter<ItemStack>
    {
        ALWAYS,
        INGREDIENT;


        public String apply(ItemStack itemStack, UidContext context) {
            if (this == ALWAYS || context == UidContext.Ingredient) {
                StringBuilder builder = new StringBuilder();
                List<MaterialVariantId> materialList = MaterialIdNBT.from(itemStack).getMaterials();
                if (!materialList.isEmpty()) {
                    builder.append(materialList.get(0));
                    for (int i = 1; i < materialList.size(); ++i) {
                        builder.append(',');
                        builder.append(materialList.get(i).getId());
                    }
                }
                return builder.toString();
            }
            return "";
        }
    }

    public static class GuiContainerTankHandler<C extends AbstractContainerMenu, T extends AbstractContainerScreen<C>>
    implements IGuiContainerHandler<T> {
        public Optional<IClickableIngredient<?>> getClickableIngredientUnderMouse(T containerScreen, double mouseX, double mouseY) {
            IScreenWithFluidTank.FluidLocation fluid = ((IScreenWithFluidTank)containerScreen).getFluidUnderMouse((int)mouseX, (int)mouseY);
            if (fluid != null) {
                return Optional.of(new ClickableIngredient<FluidStack>((IIngredientType<FluidStack>)ForgeTypes.FLUID_STACK, fluid.fluid(), fluid.location()));
            }
            return Optional.empty();
        }
    }
}

