/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.part;

import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;

public interface IMaterialItem
extends ItemLike {
    public static final String MATERIAL_TAG = "Material";

    public MaterialVariantId getMaterial(ItemStack var1);

    default public ItemStack withMaterialForDisplay(MaterialVariantId materialId) {
        ItemStack stack = new ItemStack((ItemLike)this);
        stack.m_41784_().m_128359_(MATERIAL_TAG, materialId.toString());
        return stack;
    }

    default public ItemStack withMaterial(MaterialVariantId material) {
        if (this.canUseMaterial(material.getId())) {
            return this.withMaterialForDisplay(material);
        }
        return new ItemStack((ItemLike)this);
    }

    default public boolean canUseMaterial(MaterialId mat) {
        return true;
    }

    default public boolean canUseMaterial(IMaterial mat) {
        return this.canUseMaterial(mat.getIdentifier());
    }

    default public void addVariants(CreativeModeTab.Output items) {
        if (MaterialRegistry.isFullyLoaded()) {
            MaterialVariantId materialId;
            String showOnlyId = (String)Config.COMMON.showOnlyPartMaterial.get();
            boolean added = false;
            if (!showOnlyId.isEmpty() && (materialId = MaterialVariantId.tryParse(showOnlyId)) != null && this.canUseMaterial(materialId.getId())) {
                items.m_246267_(this.withMaterialForDisplay(materialId), CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY);
                added = true;
            }
            for (IMaterial material : MaterialRegistry.getInstance().getVisibleMaterials()) {
                MaterialId id = material.getIdentifier();
                if (!this.canUseMaterial(id)) continue;
                if (showOnlyId.isEmpty()) {
                    items.m_246267_(this.withMaterial(id), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
                    continue;
                }
                items.m_246267_(this.withMaterial(id), added ? CreativeModeTab.TabVisibility.PARENT_TAB_ONLY : CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
                added = true;
            }
        }
    }

    public static MaterialVariantId getMaterialFromStack(ItemStack stack) {
        if (stack.m_41720_() instanceof IMaterialItem) {
            return ((IMaterialItem)stack.m_41720_()).getMaterial(stack);
        }
        return IMaterial.UNKNOWN_ID;
    }

    public static ItemStack withMaterial(ItemStack stack, MaterialVariantId material) {
        Item item = stack.m_41720_();
        if (item instanceof IMaterialItem) {
            ItemStack output = ((IMaterialItem)item).withMaterial(material);
            if (stack.m_41782_()) {
                if (!1.$assertionsDisabled && stack.m_41783_() == null) {
                    throw new AssertionError();
                }
                if (!1.$assertionsDisabled && output.m_41783_() == null) {
                    throw new AssertionError();
                }
                output.m_41783_().m_128391_(stack.m_41783_());
            }
            return output;
        }
        return stack;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

