/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.helper;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.common.recipe.RecipeCacheInvalidator;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.RandomMaterial;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.definition.MaterialVariant;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.tools.definition.ToolDefinition;
import slimeknights.tconstruct.library.tools.definition.module.material.ToolMaterialHook;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.library.tools.nbt.MaterialIdNBT;
import slimeknights.tconstruct.library.tools.nbt.MaterialNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.part.IToolPart;

public final class ToolBuildHandler {
    private static final MaterialId RENDER_MATERIAL = new MaterialId("tconstruct", "ui_render");
    public static final RandomMaterial RANDOM = RandomMaterial.random().build();
    private static final List<MaterialVariantId> RENDER_MATERIALS;

    private ToolBuildHandler() {
    }

    public static ItemStack buildItemFromMaterials(IModifiable tool, MaterialNBT materials) {
        return ToolStack.createTool(tool.m_5456_(), tool.getToolDefinition(), materials).createStack();
    }

    public static ToolStack buildToolRandomMaterials(IModifiable tool, RandomSource randomSource) {
        ToolDefinition definition = tool.getToolDefinition();
        List<MaterialStatsId> stats = ToolMaterialHook.stats(definition);
        return ToolStack.createTool(tool.m_5456_(), definition, RandomMaterial.build(stats, Collections.nCopies(stats.size(), RANDOM), randomSource));
    }

    public static ItemStack buildItemRandomMaterials(IModifiable tool, RandomSource randomSource) {
        return ToolBuildHandler.buildToolRandomMaterials(tool, randomSource).createStack();
    }

    public static MaterialVariantId getRenderMaterial(int index) {
        return RENDER_MATERIALS.get(index % RENDER_MATERIALS.size());
    }

    public static ItemStack buildToolForRendering(Item item, ToolDefinition definition) {
        ItemStack stack = new ItemStack((ItemLike)item);
        if (!definition.isDataLoaded() || definition.hasMaterials()) {
            stack = new MaterialIdNBT(RENDER_MATERIALS).updateStack(stack);
        }
        stack.m_41784_().m_128379_("tic_display", true);
        return stack;
    }

    public static void addVariants(CreativeModeTab.Output tab, IModifiable item) {
        ToolDefinition definition = item.getToolDefinition();
        boolean hasMaterials = definition.hasMaterials();
        if (!definition.isDataLoaded() || hasMaterials && !MaterialRegistry.isFullyLoaded()) {
            tab.m_246342_(new ItemStack((ItemLike)item));
        } else if (!hasMaterials) {
            tab.m_246342_(ToolBuildHandler.buildItemFromMaterials(item, MaterialNBT.EMPTY));
        } else {
            ItemStack tool;
            IMaterial material2;
            MaterialId materialId;
            String showOnlyId = (String)Config.COMMON.showOnlyToolMaterial.get();
            boolean added = false;
            if (!showOnlyId.isEmpty() && (materialId = MaterialId.tryParse(showOnlyId)) != null && (material2 = MaterialRegistry.getMaterial(materialId)) != IMaterial.UNKNOWN && !(tool = ToolBuildHandler.createSingleMaterial(item, MaterialVariant.of(material2))).m_41619_()) {
                tab.m_246267_(tool, CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY);
                added = true;
            }
            for (IMaterial material2 : MaterialRegistry.getInstance().getVisibleMaterials()) {
                tool = ToolBuildHandler.createSingleMaterial(item, MaterialVariant.of(material2));
                if (tool.m_41619_()) continue;
                if (showOnlyId.isEmpty()) {
                    tab.m_246267_(tool, CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
                    continue;
                }
                tab.m_246267_(tool, added ? CreativeModeTab.TabVisibility.PARENT_TAB_ONLY : CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
                added = true;
            }
        }
    }

    public static ItemStack createSingleMaterial(IModifiable item, MaterialVariant material) {
        List<MaterialStatsId> required = ToolMaterialHook.stats(item.getToolDefinition());
        MaterialNBT.Builder materials = MaterialNBT.builder();
        boolean useMaterial = false;
        for (MaterialStatsId requirement : required) {
            if (requirement.canUseMaterial(material.getId())) {
                materials.add(material);
                useMaterial = true;
                continue;
            }
            materials.add(MaterialRegistry.firstWithStatType(requirement));
        }
        if (useMaterial) {
            return ToolBuildHandler.buildItemFromMaterials(item, materials.build());
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack getDisplayPart(IToolPart toolPart, int i) {
        ItemStack item = toolPart.withMaterialForDisplay(ToolBuildHandler.getRenderMaterial(i));
        item.m_41784_().m_128379_("tic_display", true);
        return item;
    }

    static {
        RecipeCacheInvalidator.addReloadListener(client -> RANDOM.clearCache());
        RENDER_MATERIALS = Arrays.asList(MaterialVariantId.create(RENDER_MATERIAL, "head"), MaterialVariantId.create(RENDER_MATERIAL, "handle"), MaterialVariantId.create(RENDER_MATERIAL, "extra"), MaterialVariantId.create(RENDER_MATERIAL, "large"), MaterialVariantId.create(RENDER_MATERIAL, "extra_large"));
    }
}

