/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.casting.material;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.data.loadable.field.ContextKey;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.recipe.IMultiRecipe;
import slimeknights.mantle.recipe.helper.LoadableRecipeSerializer;
import slimeknights.mantle.recipe.helper.TypeAwareRecipeSerializer;
import slimeknights.tconstruct.library.json.TinkerLoadables;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.MaterialVariant;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.recipe.casting.DisplayCastingRecipe;
import slimeknights.tconstruct.library.recipe.casting.ICastingContainer;
import slimeknights.tconstruct.library.recipe.casting.ICastingRecipe;
import slimeknights.tconstruct.library.recipe.casting.IDisplayableCastingRecipe;
import slimeknights.tconstruct.library.recipe.casting.material.AbstractMaterialCastingRecipe;
import slimeknights.tconstruct.library.recipe.casting.material.MaterialCastingLookup;
import slimeknights.tconstruct.library.recipe.casting.material.MaterialFluidRecipe;
import slimeknights.tconstruct.library.tools.definition.module.material.MaterialRepairModule;
import slimeknights.tconstruct.library.tools.definition.module.material.ToolMaterialHook;
import slimeknights.tconstruct.library.tools.helper.ToolBuildHandler;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.library.tools.nbt.MaterialIdNBT;
import slimeknights.tconstruct.library.tools.nbt.MaterialNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.part.IMaterialItem;

public class ToolCastingRecipe
extends AbstractMaterialCastingRecipe
implements IMultiRecipe<IDisplayableCastingRecipe> {
    public static final RecordLoadable<ToolCastingRecipe> LOADER = RecordLoadable.create((RecordField)LoadableRecipeSerializer.TYPED_SERIALIZER.requiredField(), (RecordField)ContextKey.ID.requiredField(), (RecordField)LoadableRecipeSerializer.RECIPE_GROUP, (RecordField)CAST_FIELD, (RecordField)ITEM_COST_FIELD, (RecordField)TinkerLoadables.MODIFIABLE_ITEM.requiredField("result", r -> r.result), ToolCastingRecipe::new);
    private final IModifiable result;
    @Nullable
    private MaterialFluidRecipe cachedPartSwapping = null;
    protected List<IDisplayableCastingRecipe> multiRecipes;

    public ToolCastingRecipe(TypeAwareRecipeSerializer<?> serializer, ResourceLocation id, String group, Ingredient cast, int itemCost, IModifiable result) {
        super(serializer, id, group, cast, itemCost, true, false);
        this.result = result;
    }

    @Override
    protected MaterialFluidRecipe getFluidRecipe(ICastingContainer inv) {
        ItemStack stack = inv.getStack();
        if (stack.m_41720_() != this.result.m_5456_()) {
            return super.getFluidRecipe(inv);
        }
        Fluid fluid = inv.getFluid();
        List<MaterialStatsId> requirements = ToolMaterialHook.stats(this.result.getToolDefinition());
        int indexToCheck = requirements.size() - 1;
        MaterialVariantId currentMaterial = MaterialIdNBT.from(stack).getMaterial(indexToCheck);
        if (this.cachedPartSwapping != null && this.cachedPartSwapping.matches(fluid, currentMaterial)) {
            return this.cachedPartSwapping;
        }
        MaterialFluidRecipe casting = super.getFluidRecipe(inv);
        if (casting != MaterialFluidRecipe.EMPTY && !casting.getOutput().sameVariant(currentMaterial) && requirements.get(indexToCheck).canUseMaterial(casting.getOutput().getId())) {
            this.cachedPartSwapping = casting;
            return casting;
        }
        MaterialFluidRecipe composite = MaterialCastingLookup.getCompositeFluid(fluid, currentMaterial);
        if (composite != MaterialFluidRecipe.EMPTY) {
            this.cachedPartSwapping = composite;
            return composite;
        }
        return MaterialFluidRecipe.EMPTY;
    }

    public boolean matches(ICastingContainer inv, Level level) {
        boolean partSwapping;
        ItemStack cast = inv.getStack();
        boolean bl = partSwapping = cast.m_41720_() == this.result.m_5456_();
        if (!partSwapping && !this.getCast().test(cast)) {
            return false;
        }
        List<MaterialStatsId> requirements = ToolMaterialHook.stats(this.result.getToolDefinition());
        int numRequirements = requirements.size();
        if (numRequirements < 1 || numRequirements > 2) {
            return false;
        }
        MaterialFluidRecipe recipe = this.getFluidRecipe(inv);
        return recipe != MaterialFluidRecipe.EMPTY && requirements.get(numRequirements - 1).canUseMaterial(recipe.getOutput().getId());
    }

    public ItemStack m_8043_(RegistryAccess access) {
        return new ItemStack((ItemLike)this.result);
    }

    public ItemStack assemble(ICastingContainer inv, RegistryAccess access) {
        MaterialFluidRecipe fluidRecipe = this.getFluidRecipe(inv);
        MaterialVariant material = fluidRecipe.getOutput();
        ItemStack cast = inv.getStack();
        List<MaterialStatsId> stats = ToolMaterialHook.stats(this.result.getToolDefinition());
        if (cast.m_41720_() == this.result) {
            float repairDurability;
            ToolStack tool = ToolStack.from(cast);
            int replaceIndex = stats.size() - 1;
            tool.replaceMaterial(replaceIndex, material.getVariant());
            if (fluidRecipe.getInput() == null && (repairDurability = (float)MaterialRepairModule.getDurability(null, material.getId(), stats.get(replaceIndex))) > 0.0f && tool.getDamage() > 0) {
                ModifierEntry entry;
                repairDurability *= (float)this.itemCost / 3.0f;
                Iterator<ModifierEntry> iterator = tool.getModifierList().iterator();
                while (iterator.hasNext() && !((repairDurability = (entry = iterator.next()).getHook(ModifierHooks.REPAIR_FACTOR).getRepairFactor(tool, entry, repairDurability)) <= 0.0f)) {
                }
                if (repairDurability > 0.0f) {
                    ToolDamageUtil.repair(tool, (int)repairDurability);
                }
            }
            return tool.createStack();
        }
        MaterialNBT materials = stats.size() == 2 ? new MaterialNBT(List.of(MaterialVariant.of(IMaterialItem.getMaterialFromStack(cast)), material)) : new MaterialNBT(List.of(material));
        return ToolBuildHandler.buildItemFromMaterials(this.result, materials);
    }

    public List<IDisplayableCastingRecipe> getRecipes() {
        if (this.multiRecipes == null) {
            List<MaterialStatsId> requirements = ToolMaterialHook.stats(this.result.getToolDefinition());
            if (requirements.isEmpty()) {
                this.multiRecipes = List.of();
            } else {
                Function<MaterialVariant, MaterialNBT> materials;
                RecipeType<?> type = this.m_6671_();
                List<ItemStack> castItems = Arrays.asList(this.getCast().m_43908_());
                MaterialStatsId requirement = requirements.get(requirements.size() - 1);
                if (requirements.size() > 1) {
                    MaterialVariant firstMaterial = MaterialVariant.of(MaterialRegistry.firstWithStatType(requirements.get(0)));
                    materials = mat -> new MaterialNBT(List.of(firstMaterial, mat));
                } else {
                    materials = mat -> new MaterialNBT(List.of(mat));
                }
                this.multiRecipes = MaterialCastingLookup.getAllCastingFluids().stream().filter(recipe -> {
                    MaterialVariant output = recipe.getOutput();
                    return !output.isUnknown() && !output.get().isHidden() && requirement.canUseMaterial(output.getId());
                }).map(recipe -> {
                    List<FluidStack> fluids = this.resizeFluids(recipe.getFluids());
                    int fluidAmount = fluids.stream().mapToInt(FluidStack::getAmount).max().orElse(0);
                    return new DisplayCastingRecipe(type, castItems, fluids, ToolBuildHandler.buildItemFromMaterials(this.result, (MaterialNBT)materials.apply(recipe.getOutput())), ICastingRecipe.calcCoolingTime(recipe.getTemperature(), this.itemCost * fluidAmount), this.isConsumed());
                }).collect(Collectors.toList());
            }
        }
        return this.multiRecipes;
    }
}

