/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.casting.material;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.data.loadable.field.ContextKey;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.recipe.helper.LoadableRecipeSerializer;
import slimeknights.mantle.recipe.helper.TypeAwareRecipeSerializer;
import slimeknights.tconstruct.library.materials.definition.MaterialVariant;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.recipe.casting.DisplayCastingRecipe;
import slimeknights.tconstruct.library.recipe.casting.ICastingContainer;
import slimeknights.tconstruct.library.recipe.casting.ICastingRecipe;
import slimeknights.tconstruct.library.recipe.casting.IDisplayableCastingRecipe;
import slimeknights.tconstruct.library.recipe.casting.material.MaterialCastingLookup;
import slimeknights.tconstruct.library.recipe.casting.material.MaterialCastingRecipe;
import slimeknights.tconstruct.library.recipe.casting.material.MaterialFluidRecipe;
import slimeknights.tconstruct.library.tools.part.IMaterialItem;

public class CompositeCastingRecipe
extends MaterialCastingRecipe {
    public static final RecordLoadable<CompositeCastingRecipe> LOADER = RecordLoadable.create((RecordField)LoadableRecipeSerializer.TYPED_SERIALIZER.requiredField(), (RecordField)ContextKey.ID.requiredField(), (RecordField)LoadableRecipeSerializer.RECIPE_GROUP, (RecordField)RESULT_FIELD, (RecordField)ITEM_COST_FIELD, (RecordField)MaterialStatsId.PARSER.nullableField("casting_stat_conflict", r -> r.castingStatConflict), CompositeCastingRecipe::new);
    @Nullable
    private final MaterialStatsId castingStatConflict;

    public CompositeCastingRecipe(TypeAwareRecipeSerializer<?> serializer, ResourceLocation id, String group, IMaterialItem result, int itemCost, @Nullable MaterialStatsId castingStatConflict) {
        super(serializer, id, group, Ingredient.m_43929_((ItemLike[])new ItemLike[]{result}), itemCost, result, true, false);
        this.castingStatConflict = castingStatConflict;
    }

    @Override
    protected MaterialFluidRecipe getFluidRecipe(ICastingContainer inv) {
        MaterialFluidRecipe recipe;
        Fluid fluid = inv.getFluid();
        if (this.castingStatConflict != null && (recipe = MaterialCastingLookup.getCastingFluid(fluid)) != MaterialFluidRecipe.EMPTY && this.castingStatConflict.canUseMaterial(recipe.getOutput().getId())) {
            return MaterialFluidRecipe.EMPTY;
        }
        return MaterialCastingLookup.getCompositeFluid(fluid, IMaterialItem.getMaterialFromStack(inv.getStack()));
    }

    @Override
    public List<IDisplayableCastingRecipe> getRecipes() {
        if (this.multiRecipes == null) {
            RecipeType<?> type = this.m_6671_();
            ImmutableList.Builder recipes = ImmutableList.builder();
            for (MaterialFluidRecipe recipe : MaterialCastingLookup.getAllCompositeFluids()) {
                MaterialVariant output = recipe.getOutput();
                MaterialVariant input = recipe.getInput();
                if (output.isUnknown() || input == null || input.isUnknown() || output.get().isHidden() || input.get().isHidden() || !this.result.canUseMaterial(output.getId()) || !this.result.canUseMaterial(input.getId())) continue;
                List<FluidStack> fluids = recipe.getFluids();
                if (this.castingStatConflict != null) {
                    fluids = fluids.stream().filter(fluid -> {
                        MaterialFluidRecipe fluidRecipe = MaterialCastingLookup.getCastingFluid(fluid.getFluid());
                        return fluidRecipe == MaterialFluidRecipe.EMPTY || !this.castingStatConflict.canUseMaterial(fluidRecipe.getOutput().getId());
                    }).toList();
                }
                if (fluids.isEmpty()) continue;
                fluids = this.resizeFluids(recipe.getFluids());
                recipes.add((Object)new DisplayCastingRecipe(type, List.of(this.result.withMaterial(input.getVariant())), fluids, this.result.withMaterial(output.getVariant()), ICastingRecipe.calcCoolingTime(recipe.getTemperature(), this.itemCost * fluids.stream().mapToInt(FluidStack::getAmount).max().orElse(0)), this.isConsumed()));
            }
            this.multiRecipes = recipes.build();
        }
        return this.multiRecipes;
    }
}

