/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.materials;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.BooleanLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.data.registry.GenericLoaderRegistry;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.json.IntRange;
import slimeknights.tconstruct.library.json.TinkerLoadables;
import slimeknights.tconstruct.library.materials.IMaterialRegistry;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.tools.nbt.MaterialNBT;

public abstract class RandomMaterial
implements GenericLoaderRegistry.IHaveLoader {
    public static final GenericLoaderRegistry<RandomMaterial> LOADER = new GenericLoaderRegistry("Random Material", false);
    private static boolean initialized = false;

    public static void init() {
        if (initialized) {
            return;
        }
        initialized = true;
        LOADER.register(TConstruct.getResource("fixed"), Fixed.LOADER);
        LOADER.register(TConstruct.getResource("first"), First.LOADER);
        LOADER.register(TConstruct.getResource("random"), Randomized.LOADER);
    }

    public static RandomMaterial fixed(MaterialId materialId) {
        return new Fixed(materialId);
    }

    public static RandomMaterial firstWithStat() {
        return First.INSTANCE;
    }

    public static RandomBuilder random() {
        return new RandomBuilder();
    }

    public abstract MaterialVariantId getMaterial(MaterialStatsId var1, RandomSource var2);

    public void clearCache() {
    }

    public static MaterialNBT build(List<MaterialStatsId> statTypes, List<RandomMaterial> materials, RandomSource random) {
        int i;
        MaterialNBT.Builder builder = MaterialNBT.builder();
        int max = Math.min(materials.size(), statTypes.size());
        for (i = 0; i < max; ++i) {
            builder.add(materials.get(i).getMaterial(statTypes.get(i), random));
        }
        for (i = max; i < statTypes.size(); ++i) {
            builder.add(MaterialRegistry.firstWithStatType(statTypes.get(i)));
        }
        return builder.build();
    }

    private static class Fixed
    extends RandomMaterial {
        private static final RecordLoadable<Fixed> LOADER = RecordLoadable.create((RecordField)MaterialVariantId.LOADABLE.requiredField("material", r -> r.material), Fixed::new);
        private final MaterialVariantId material;

        @Override
        public MaterialVariantId getMaterial(MaterialStatsId statType, RandomSource random) {
            return this.material;
        }

        public RecordLoadable<Fixed> getLoader() {
            return LOADER;
        }

        public Fixed(MaterialVariantId material) {
            this.material = material;
        }
    }

    private static class First
    extends RandomMaterial {
        private static final First INSTANCE = new First();
        public static final GenericLoaderRegistry.SingletonLoader<First> LOADER = new GenericLoaderRegistry.SingletonLoader((Object)INSTANCE);

        @Override
        public MaterialVariantId getMaterial(MaterialStatsId statType, RandomSource random) {
            return MaterialRegistry.firstWithStatType(statType).getIdentifier();
        }

        public GenericLoaderRegistry.SingletonLoader<First> getLoader() {
            return LOADER;
        }

        private First() {
        }
    }

    private static class Randomized
    extends RandomMaterial
    implements Function<MaterialStatsId, List<MaterialId>> {
        public static final IntRange TIER_RANGE = new IntRange(0, Integer.MAX_VALUE);
        public static final RecordLoadable<Randomized> LOADER = RecordLoadable.create(TIER_RANGE.defaultField("tier", r -> r.tier), (RecordField)BooleanLoadable.INSTANCE.defaultField("allow_hidden", (Object)false, false, r -> r.allowHidden), (RecordField)TinkerLoadables.MATERIAL_TAGS.nullableField("tag", r -> r.tag), Randomized::new);
        private final IntRange tier;
        private final boolean allowHidden;
        @Nullable
        private final TagKey<IMaterial> tag;
        private final Map<MaterialStatsId, List<MaterialId>> materialChoices = new ConcurrentHashMap<MaterialStatsId, List<MaterialId>>();

        @Override
        public List<MaterialId> apply(MaterialStatsId statType) {
            IMaterialRegistry registry = MaterialRegistry.getInstance();
            List<MaterialId> choices = MaterialRegistry.getInstance().getAllMaterials().stream().filter(material -> {
                MaterialId id = material.getIdentifier();
                return !(!this.tier.test(material.getTier()) || !this.allowHidden && material.isHidden() || this.tag != null && !registry.isInTag(id, this.tag) || !registry.getMaterialStats(id, statType).isPresent());
            }).map(IMaterial::getIdentifier).toList();
            if (choices.isEmpty()) {
                TConstruct.LOG.warn("Random material found no options for statType={}, tier={}, allowHidden={}", (Object)statType, (Object)this.tier, (Object)this.allowHidden);
            }
            return choices;
        }

        @Override
        public void clearCache() {
            this.materialChoices.clear();
        }

        @Override
        public MaterialId getMaterial(MaterialStatsId statType, RandomSource random) {
            List<MaterialId> materialChoices = this.materialChoices.computeIfAbsent(statType, this);
            if (materialChoices.isEmpty()) {
                return MaterialRegistry.firstWithStatType(statType).getIdentifier();
            }
            return materialChoices.get(random.m_188503_(materialChoices.size()));
        }

        public RecordLoadable<Randomized> getLoader() {
            return LOADER;
        }

        public Randomized(IntRange tier, boolean allowHidden, @Nullable TagKey<IMaterial> tag) {
            this.tier = tier;
            this.allowHidden = allowHidden;
            this.tag = tag;
        }
    }

    public static class RandomBuilder {
        private IntRange tier = Randomized.TIER_RANGE;
        private boolean allowHidden = false;
        @Nullable
        private TagKey<IMaterial> tag;

        public RandomBuilder tier(int tier) {
            this.tier = Randomized.TIER_RANGE.exactly(tier);
            return this;
        }

        public RandomBuilder tier(int min, int max) {
            this.tier = Randomized.TIER_RANGE.range(min, max);
            return this;
        }

        public RandomBuilder minTier(int min) {
            this.tier = Randomized.TIER_RANGE.min(min);
            return this;
        }

        public RandomBuilder maxTier(int max) {
            this.tier = Randomized.TIER_RANGE.max(max);
            return this;
        }

        public RandomBuilder allowHidden() {
            this.allowHidden = true;
            return this;
        }

        public RandomMaterial build() {
            return new Randomized(this.tier, this.allowHidden, this.tag);
        }

        private RandomBuilder() {
        }

        public RandomBuilder tag(@Nullable TagKey<IMaterial> tag) {
            this.tag = tag;
            return this;
        }
    }
}

