/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tables.block.entity.chest;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import slimeknights.mantle.block.entity.MantleBlockEntity;
import slimeknights.mantle.block.entity.NameableBlockEntity;
import slimeknights.tconstruct.tables.block.entity.inventory.IChestItemHandler;
import slimeknights.tconstruct.tables.menu.TinkerChestContainerMenu;

public abstract class AbstractChestBlockEntity
extends NameableBlockEntity {
    private static final String KEY_ITEMS = "Items";
    private final IChestItemHandler itemHandler;
    private final LazyOptional<IItemHandler> capability;

    protected AbstractChestBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, Component name, IChestItemHandler itemHandler) {
        super(type, pos, state, name);
        itemHandler.setParent((MantleBlockEntity)this);
        this.itemHandler = itemHandler;
        this.capability = LazyOptional.of(() -> itemHandler);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.capability.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.capability.invalidate();
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int menuId, Inventory playerInventory, Player playerEntity) {
        return new TinkerChestContainerMenu(menuId, playerInventory, this);
    }

    public boolean canInsert(Player player, ItemStack heldItem) {
        return true;
    }

    public void m_183515_(CompoundTag tags) {
        super.m_183515_(tags);
        CompoundTag handlerNBT = (CompoundTag)this.itemHandler.serializeNBT();
        tags.m_128365_(KEY_ITEMS, (Tag)handlerNBT.m_128437_(KEY_ITEMS, 10));
    }

    public void readInventory(CompoundTag tags) {
        CompoundTag handlerNBT = new CompoundTag();
        handlerNBT.m_128365_(KEY_ITEMS, (Tag)tags.m_128437_(KEY_ITEMS, 10));
        this.itemHandler.deserializeNBT((Tag)handlerNBT);
    }

    public void m_142466_(CompoundTag tags) {
        super.m_142466_(tags);
        this.readInventory(tags);
    }

    public IChestItemHandler getItemHandler() {
        return this.itemHandler;
    }
}

