/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.util.GsonHelper;
import slimeknights.mantle.client.ResourceColorManager;
import slimeknights.mantle.data.loadable.Loadable;
import slimeknights.mantle.data.loadable.field.LoadableField;
import slimeknights.mantle.data.loadable.primitive.IntLoadable;
import slimeknights.mantle.data.loadable.primitive.StringLoadable;
import slimeknights.mantle.util.typed.TypedMap;
import slimeknights.tconstruct.TConstruct;

public final class SlotType {
    public static final StringLoadable<SlotType> LOADABLE = StringLoadable.DEFAULT.comapFlatMap((name, error) -> {
        if (!SlotType.isValidName(name)) {
            throw error.create("Invalid slot type name '" + name + "'");
        }
        return SlotType.getOrCreate(name);
    }, SlotType::getName);
    private static final String KEY_SLOT = TConstruct.makeTranslationKey("stat", "slot.");
    private static final String KEY_PREFIX = KEY_SLOT + "prefix.";
    public static final String KEY_DISPLAY = KEY_SLOT + "display.";
    private static final Map<String, SlotType> SLOT_TYPES = new HashMap<String, SlotType>();
    private static final List<SlotType> ALL_SLOTS = new ArrayList<SlotType>();
    private static final Pattern VALIDATOR = Pattern.compile("^[a-z0-9_]*$");
    public static final SlotType UPGRADE = SlotType.getOrCreate("upgrades");
    public static final SlotType DEFENSE = SlotType.getOrCreate("defense");
    public static final SlotType ABILITY = SlotType.getOrCreate("abilities");
    public static final SlotType SOUL = SlotType.getOrCreate("souls");
    private final String name;
    private TextColor color = null;
    private Component displayName = null;

    public static void init() {
    }

    public static boolean isValidName(String name) {
        return VALIDATOR.matcher(name).matches();
    }

    public static SlotType getOrCreate(String name) {
        if (SLOT_TYPES.containsKey(name)) {
            return SLOT_TYPES.get(name);
        }
        if (!SlotType.isValidName(name)) {
            throw new IllegalArgumentException("Non [a-z0-9_] character in slot name: " + name);
        }
        SlotType type = new SlotType(name);
        SLOT_TYPES.put(name, type);
        ALL_SLOTS.add(type);
        return type;
    }

    @Nullable
    public static SlotType getIfPresent(String name) {
        return SLOT_TYPES.get(name);
    }

    public static SlotType read(FriendlyByteBuf buffer) {
        return SlotType.getOrCreate(buffer.m_130277_());
    }

    public static Collection<SlotType> getAllSlotTypes() {
        return ALL_SLOTS;
    }

    public String getPrefix() {
        return KEY_PREFIX + this.name;
    }

    public Component getDisplayName() {
        if (this.displayName == null) {
            this.displayName = Component.m_237115_((String)(KEY_DISPLAY + this.name));
        }
        return this.displayName;
    }

    public TextColor getColor() {
        if (this.color == null) {
            this.color = ResourceColorManager.getTextColor((String)(KEY_SLOT + this.name));
        }
        return this.color;
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.name);
    }

    public String toString() {
        return "SlotType{" + this.name + "}";
    }

    private SlotType(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public record SlotCount(SlotType type, int count) {
        public static final Loadable<SlotCount> LOADABLE = new Loadable<SlotCount>(){

            public SlotCount convert(JsonElement element, String key, TypedMap context) {
                JsonObject json = GsonHelper.m_13918_((JsonElement)element, (String)key);
                if (json.entrySet().size() != 1) {
                    throw new JsonSyntaxException("Cannot set multiple slot types");
                }
                Map.Entry entry = (Map.Entry)json.entrySet().iterator().next();
                String typeString = (String)entry.getKey();
                if (!SlotType.isValidName(typeString)) {
                    throw new JsonSyntaxException("Invalid slot type name '" + typeString + "'");
                }
                SlotType slotType = SlotType.getOrCreate(typeString);
                int slots = IntLoadable.FROM_ONE.convert((JsonElement)entry.getValue(), "count", context);
                return new SlotCount(slotType, slots);
            }

            public JsonElement serialize(SlotCount slots) {
                JsonObject json = new JsonObject();
                json.addProperty(slots.type.getName(), (Number)slots.count);
                return json;
            }

            public SlotCount decode(FriendlyByteBuf buffer, TypedMap context) {
                return new SlotCount(SlotType.read(buffer), buffer.m_130242_());
            }

            public void encode(FriendlyByteBuf buffer, SlotCount slots) {
                slots.type().write(buffer);
                buffer.m_130130_(slots.count());
            }

            public <P> LoadableField<SlotCount, P> nullableField(String key, Function<P, SlotCount> getter) {
                return new NullableSlotCountField<P>(key, getter);
            }
        };

        @Nullable
        public static SlotType type(@Nullable SlotCount count) {
            if (count == null) {
                return null;
            }
            return count.type();
        }

        public static int get(@Nullable SlotCount slots, SlotType type) {
            if (slots != null && slots.type() == type) {
                return slots.count();
            }
            return 0;
        }

        @Override
        public String toString() {
            return "SlotCount{" + this.type.name + ": " + this.count + "}";
        }

        private record NullableSlotCountField<P>(String key, Function<P, SlotCount> getter) implements LoadableField<SlotCount, P>
        {
            @Nullable
            public SlotCount get(JsonObject json, TypedMap context) {
                return (SlotCount)LOADABLE.getOrDefault(json, this.key, null, context);
            }

            public void serialize(P parent, JsonObject json) {
                SlotCount count = this.getter.apply(parent);
                if (count != null) {
                    json.add(this.key, LOADABLE.serialize((Object)count));
                }
            }

            @Nullable
            public SlotCount decode(FriendlyByteBuf buffer, TypedMap context) {
                int count = buffer.m_130242_();
                if (count == 0) {
                    return null;
                }
                return new SlotCount(SlotType.read(buffer), count);
            }

            public void encode(FriendlyByteBuf buffer, P parent) {
                SlotCount slotCount = this.getter.apply(parent);
                if (slotCount == null) {
                    buffer.m_130130_(0);
                } else {
                    buffer.m_130130_(slotCount.count);
                    slotCount.type.write(buffer);
                }
            }
        }
    }
}

