/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.data.tinkering;

import com.google.gson.JsonObject;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.enchantment.Enchantment;
import slimeknights.mantle.data.GenericDataProvider;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.ModifierId;

public abstract class AbstractEnchantmentToModifierProvider
extends GenericDataProvider {
    private final JsonObject enchantmentMap = new JsonObject();

    public AbstractEnchantmentToModifierProvider(PackOutput packOutput) {
        super(packOutput, PackOutput.Target.DATA_PACK, "tinkering");
    }

    protected abstract void addEnchantmentMappings();

    public CompletableFuture<?> m_213708_(CachedOutput pCache) {
        this.enchantmentMap.entrySet().clear();
        this.addEnchantmentMappings();
        return this.saveJson(pCache, TConstruct.getResource("enchantments_to_modifiers"), this.enchantmentMap);
    }

    protected void add(Enchantment enchantment, ModifierId modifierId) {
        String key = Objects.requireNonNull(BuiltInRegistries.f_256876_.m_7981_((Object)enchantment)).toString();
        if (this.enchantmentMap.has(key)) {
            throw new IllegalArgumentException("Duplicate enchantment " + key);
        }
        this.enchantmentMap.addProperty(key, modifierId.toString());
    }

    protected void add(TagKey<Enchantment> tag, ModifierId modifierId) {
        String key = "#" + tag.f_203868_();
        if (this.enchantmentMap.has(key)) {
            throw new IllegalArgumentException("Duplicate enchantment tag " + tag.f_203868_());
        }
        this.enchantmentMap.addProperty(key, modifierId.toString());
    }

    protected void add(ResourceLocation tag, ModifierId modifierId) {
        this.add((TagKey<Enchantment>)TagKey.m_203882_((ResourceKey)Registries.f_256762_, (ResourceLocation)tag), modifierId);
    }
}

