/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.modifiers;

import com.mojang.math.Transformation;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.armortrim.TrimMaterial;
import slimeknights.mantle.client.model.util.MantleItemLayerModel;
import slimeknights.mantle.data.loadable.common.ColorLoadable;
import slimeknights.mantle.util.ItemLayerPixels;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.modifiers.IBakedModifierModel;
import slimeknights.tconstruct.library.client.modifiers.IUnbakedModifierModel;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.tools.modifiers.slotless.TrimModifier;

public enum TrimModifierModel implements IBakedModifierModel
{
    INSTANCE;

    private static final Map<String, TrimTexture>[] TEXTURE_CACHE;
    public static final ResourceLocation[] TRIM_TEXTURES;
    public static final IUnbakedModifierModel UNBAKED_INSTANCE;

    @Override
    public Object getCacheKey(IToolStackView tool, ModifierEntry modifier) {
        return tool.getPersistentData().getString(TrimModifier.TRIM_MATERIAL);
    }

    @Override
    public void addQuads(IToolStackView tool, ModifierEntry modifier, Function<Material, TextureAtlasSprite> spriteGetter, Transformation transforms, boolean isLarge, int startTintIndex, Consumer<Collection<BakedQuad>> quadConsumer, @Nullable ItemLayerPixels pixels) {
        Item item;
        String materialId;
        if (!isLarge && !(materialId = tool.getPersistentData().getString(TrimModifier.TRIM_MATERIAL)).isEmpty() && (item = tool.getItem()) instanceof ArmorItem) {
            ArmorItem armor = (ArmorItem)item;
            Map<String, TrimTexture> cache = TEXTURE_CACHE[armor.m_266204_().ordinal()];
            TrimTexture texture = cache.get(materialId);
            if (texture == null) {
                texture = TrimTexture.EMPTY;
                ClientLevel level = Minecraft.m_91087_().f_91073_;
                if (level != null) {
                    TrimMaterial material = (TrimMaterial)level.m_9598_().m_175515_(Registries.f_266076_).m_7745_(ResourceLocation.m_135820_((String)materialId));
                    if (material != null) {
                        ResourceLocation root = TRIM_TEXTURES[armor.m_266204_().ordinal()];
                        ResourceLocation path = root.m_266382_("_" + material.f_265854_());
                        TextureAtlasSprite sprite = spriteGetter.apply(new Material(InventoryMenu.f_39692_, path));
                        int color = -1;
                        if (MissingTextureAtlasSprite.m_118071_().equals((Object)sprite.m_245424_().m_246162_())) {
                            sprite = spriteGetter.apply(new Material(InventoryMenu.f_39692_, root));
                            TextColor textColor = material.f_266021_().m_7383_().m_131135_();
                            if (textColor != null) {
                                color = textColor.m_131265_() | 0xFF000000;
                            }
                            TConstruct.LOG.error("Missing material specific texture {}, defaulting to tinting base texture #{}", (Object)path, (Object)ColorLoadable.NO_ALPHA.getString((Object)color));
                        }
                        texture = new TrimTexture(sprite, color);
                    }
                    cache.put(materialId, texture);
                }
            }
            if (texture.sprite != null) {
                quadConsumer.accept((Collection<BakedQuad>)MantleItemLayerModel.getQuadsForSprite((int)texture.color, (int)-1, (TextureAtlasSprite)texture.sprite, (Transformation)transforms, (int)0, (ItemLayerPixels)pixels));
            }
        }
    }

    static {
        TEXTURE_CACHE = new Map[4];
        TRIM_TEXTURES = new ResourceLocation[4];
        for (ArmorItem.Type type : ArmorItem.Type.values()) {
            TrimModifierModel.TEXTURE_CACHE[type.ordinal()] = new HashMap<String, TrimTexture>();
            TrimModifierModel.TRIM_TEXTURES[type.ordinal()] = new ResourceLocation("trims/items/" + type.m_266355_() + "_trim");
        }
        UNBAKED_INSTANCE = (smallGetter, largeGetter) -> {
            for (ArmorItem.Type type : ArmorItem.Type.values()) {
                TEXTURE_CACHE[type.ordinal()].clear();
            }
            return INSTANCE;
        };
    }

    private record TrimTexture(@Nullable TextureAtlasSprite sprite, int color) {
        public static final TrimTexture EMPTY = new TrimTexture(null, -1);
    }
}

