/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.traits.general;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.Sounds;
import slimeknights.tconstruct.library.events.teleport.EnderportingTeleportEvent;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeHitModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.mining.BlockHarvestModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ranged.ProjectileHitModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ranged.ProjectileLaunchModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.special.PlantHarvestModifierHook;
import slimeknights.tconstruct.library.modifiers.impl.NoLevelsModifier;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.context.ToolHarvestContext;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;

public class EnderportingModifier
extends NoLevelsModifier
implements PlantHarvestModifierHook,
ProjectileHitModifierHook,
ProjectileLaunchModifierHook,
BlockHarvestModifierHook,
MeleeHitModifierHook {
    private static final ResourceLocation PRIMARY_ARROW = TConstruct.getResource("enderporting_primary");
    private static final Set<RelativeMovement> PACKET_FLAGS = ImmutableSet.of((Object)RelativeMovement.X, (Object)RelativeMovement.Y, (Object)RelativeMovement.Z);

    @Override
    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        hookBuilder.addHook(this, ModifierHooks.PLANT_HARVEST, ModifierHooks.PROJECTILE_HIT, ModifierHooks.PROJECTILE_LAUNCH, ModifierHooks.BLOCK_HARVEST, ModifierHooks.MELEE_HIT);
    }

    @Override
    public int getPriority() {
        return 45;
    }

    private static boolean tryTeleport(LivingEntity living, double x, double y, double z) {
        Level world = living.m_20193_();
        if (world.f_46443_) {
            return false;
        }
        float scaledWidth = living.m_20205_() * 0.8f;
        float eyeHeight = living.m_20192_();
        AABB aabb = AABB.m_165882_((Vec3)new Vec3(x, y + (double)(eyeHeight / 2.0f), z), (double)scaledWidth, (double)eyeHeight, (double)scaledWidth);
        boolean didCollide = world.m_186434_((Entity)living, aabb).iterator().hasNext();
        if (didCollide && living.m_20206_() > 1.0f) {
            aabb = aabb.m_82386_(0.0, -1.0, 0.0);
            didCollide = world.m_186434_((Entity)living, aabb).iterator().hasNext();
            y -= 1.0;
        }
        if (!didCollide) {
            EnderportingTeleportEvent event = new EnderportingTeleportEvent(living, x, y, z);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (!event.isCanceled()) {
                if (living instanceof ServerPlayer) {
                    ServerPlayer playerMP = (ServerPlayer)living;
                    playerMP.f_8906_.m_9780_(x, y, z, playerMP.m_146908_(), playerMP.m_146909_(), PACKET_FLAGS);
                } else {
                    living.m_6034_(event.getTargetX(), event.getTargetY(), event.getTargetZ());
                }
                if (world instanceof ServerLevel) {
                    ServerLevel serverWorld = (ServerLevel)world;
                    for (int i = 0; i < 32; ++i) {
                        serverWorld.m_8767_((ParticleOptions)ParticleTypes.f_123760_, living.m_20185_(), living.m_20186_() + world.f_46441_.m_188500_() * 2.0, living.m_20189_(), 1, world.f_46441_.m_188583_(), 0.0, world.f_46441_.m_188583_(), 0.0);
                    }
                }
                world.m_6263_(null, living.m_20185_(), living.m_20186_(), living.m_20189_(), Sounds.ENDERPORTING.getSound(), living.m_5720_(), 1.0f, 1.0f);
                return true;
            }
        }
        return false;
    }

    @Override
    public void afterMeleeHit(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float damageDealt) {
        LivingEntity target;
        if (!context.isExtraAttack() && (target = context.getLivingTarget()) != null) {
            LivingEntity attacker = context.getAttacker();
            Vec3 oldPosition = attacker.m_20182_();
            if (EnderportingModifier.tryTeleport(attacker, target.m_20185_(), target.m_20186_(), target.m_20189_())) {
                EnderportingModifier.tryTeleport(target, oldPosition.f_82479_, oldPosition.f_82480_, oldPosition.f_82481_);
                ToolDamageUtil.damageAnimated(tool, 2, attacker, context.getSlotType());
            }
        }
    }

    @Override
    public void finishHarvest(IToolStackView tool, ModifierEntry modifier, ToolHarvestContext context, int harvested) {
        if (harvested > 0 && context.canHarvest()) {
            BlockPos pos = context.getPos();
            LivingEntity living = context.getLiving();
            if (EnderportingModifier.tryTeleport(living, (float)pos.m_123341_() + 0.5f, pos.m_123342_(), (float)pos.m_123343_() + 0.5f)) {
                ToolDamageUtil.damageAnimated(tool, 2, living);
            }
        }
    }

    @Override
    public void afterHarvest(IToolStackView tool, ModifierEntry modifier, UseOnContext context, ServerLevel world, BlockState state, BlockPos pos) {
        Player living;
        if (context.m_8083_().equals((Object)pos) && (living = context.m_43723_()) != null && EnderportingModifier.tryTeleport((LivingEntity)living, (float)pos.m_123341_() + 0.5f, pos.m_123342_(), (float)pos.m_123343_() + 0.5f)) {
            ToolDamageUtil.damageAnimated(tool, 2, (LivingEntity)living, context.m_43724_());
        }
    }

    @Override
    public boolean onProjectileHitEntity(ModifierNBT modifiers, ModDataNBT persistentData, ModifierEntry modifier, Projectile projectile, EntityHitResult hit, @Nullable LivingEntity attacker, @Nullable LivingEntity target) {
        if (attacker != null && attacker != target && persistentData.getBoolean(PRIMARY_ARROW)) {
            Entity hitEntity = hit.m_82443_();
            Vec3 oldPosition = attacker.m_20182_();
            if (attacker.m_9236_() == projectile.m_9236_() && EnderportingModifier.tryTeleport(attacker, hitEntity.m_20185_(), hitEntity.m_20186_(), hitEntity.m_20189_()) && target != null) {
                EnderportingModifier.tryTeleport(target, oldPosition.f_82479_, oldPosition.f_82480_, oldPosition.f_82481_);
            }
        }
        return false;
    }

    @Override
    public boolean onProjectileHitBlock(ModifierNBT modifiers, ModDataNBT persistentData, ModifierEntry modifier, Projectile projectile, BlockHitResult hit, @Nullable LivingEntity attacker) {
        if (attacker != null && persistentData.getBoolean(PRIMARY_ARROW)) {
            BlockPos target = hit.m_82425_().m_121945_(hit.m_82434_());
            if (attacker.m_9236_() == projectile.m_9236_() && EnderportingModifier.tryTeleport(attacker, (float)target.m_123341_() + 0.5f, target.m_123342_(), (float)target.m_123343_() + 0.5f)) {
                projectile.m_146870_();
            }
        }
        return false;
    }

    @Override
    public void onProjectileLaunch(IToolStackView tool, ModifierEntry modifier, LivingEntity shooter, Projectile projectile, @Nullable AbstractArrow arrow, ModDataNBT persistentData, boolean primary) {
        if (primary) {
            ToolDamageUtil.damageAnimated(tool, 10, shooter, shooter.m_7655_());
            persistentData.putBoolean(PRIMARY_ARROW, true);
        }
    }
}

