/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.client.screen;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.fluids.capability.IFluidHandler;
import slimeknights.mantle.client.screen.ElementScreen;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.GuiUtil;
import slimeknights.tconstruct.smeltery.block.entity.controller.AlloyerBlockEntity;
import slimeknights.tconstruct.smeltery.block.entity.module.FuelModule;
import slimeknights.tconstruct.smeltery.block.entity.module.alloying.MixerAlloyTank;
import slimeknights.tconstruct.smeltery.client.screen.IScreenWithFluidTank;
import slimeknights.tconstruct.smeltery.client.screen.module.GuiFuelModule;
import slimeknights.tconstruct.smeltery.client.screen.module.GuiTankModule;
import slimeknights.tconstruct.smeltery.menu.AlloyerContainerMenu;

public class AlloyerScreen
extends AbstractContainerScreen<AlloyerContainerMenu>
implements IScreenWithFluidTank {
    private static final int[] INPUT_TANK_START_X = new int[]{54, 22, 38, 70, 6};
    private static final ResourceLocation BACKGROUND = TConstruct.getResource("textures/gui/alloyer.png");
    private static final ElementScreen SCALA = new ElementScreen(BACKGROUND, 176, 0, 34, 52, 256, 256);
    private static final ElementScreen FUEL_SLOT = new ElementScreen(BACKGROUND, 176, 52, 18, 36, 256, 256);
    private static final ElementScreen FUEL_TANK = new ElementScreen(BACKGROUND, 194, 52, 14, 38, 256, 256);
    private static final ElementScreen INPUT_TANK = new ElementScreen(BACKGROUND, 208, 52, 16, 54, 256, 256);
    private final GuiFuelModule fuel;
    private final GuiTankModule outputTank;
    private GuiTankModule[] inputTanks = new GuiTankModule[0];

    public AlloyerScreen(AlloyerContainerMenu container, Inventory inv, Component name) {
        super((AbstractContainerMenu)container, inv, name);
        AlloyerBlockEntity te = (AlloyerBlockEntity)container.getTile();
        if (te != null) {
            FuelModule fuelModule = te.getFuelModule();
            this.fuel = new GuiFuelModule(this, fuelModule, 153, 32, 12, 36, 152, 15, container.isHasFuelSlot(), BACKGROUND);
            this.outputTank = new GuiTankModule(this, (IFluidHandler)te.getTank(), 114, 16, 34, 52, AlloyerContainerMenu.TOOLTIP_FORMAT);
            this.updateTanks();
        } else {
            this.fuel = null;
            this.outputTank = null;
        }
    }

    private void updateTanks() {
        AlloyerBlockEntity te = (AlloyerBlockEntity)((AlloyerContainerMenu)this.f_97732_).getTile();
        if (te != null) {
            MixerAlloyTank alloyTank = te.getAlloyTank();
            int numTanks = alloyTank.getTanks();
            GuiTankModule[] tanks = new GuiTankModule[numTanks];
            int max = Math.min(numTanks, 5);
            for (int i = 0; i < max; ++i) {
                tanks[i] = new GuiTankModule(this, alloyTank.getFluidHandler(i), INPUT_TANK_START_X[i], 16, 14, 52, AlloyerContainerMenu.TOOLTIP_FORMAT);
            }
            this.inputTanks = tanks;
        }
    }

    protected void m_181908_() {
        super.m_181908_();
        AlloyerBlockEntity te = (AlloyerBlockEntity)((AlloyerContainerMenu)this.f_97732_).getTile();
        if (te != null && te.getAlloyTank().getTanks() != this.inputTanks.length) {
            this.updateTanks();
        }
    }

    public void m_88315_(GuiGraphics graphics, int x, int y, float partialTicks) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, x, y, partialTicks);
        this.m_280072_(graphics, x, y);
    }

    protected void m_7286_(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        GuiUtil.drawBackground(graphics, this, BACKGROUND);
        if (this.outputTank != null) {
            this.outputTank.draw(graphics);
        }
        for (GuiTankModule tankModule : this.inputTanks) {
            INPUT_TANK.draw(graphics, tankModule.getX() - 1 + this.f_97735_, tankModule.getY() - 1 + this.f_97736_);
        }
        if (this.fuel != null) {
            if (((AlloyerContainerMenu)this.f_97732_).isHasFuelSlot()) {
                FUEL_SLOT.draw(graphics, this.f_97735_ + 150, this.f_97736_ + 31);
            } else {
                FUEL_TANK.draw(graphics, this.f_97735_ + 152, this.f_97736_ + 31);
            }
            this.fuel.draw(graphics);
        }
        for (GuiTankModule tankModule : this.inputTanks) {
            tankModule.draw(graphics);
        }
    }

    protected void m_280003_(GuiGraphics graphics, int mouseX, int mouseY) {
        super.m_280003_(graphics, mouseX, mouseY);
        int checkX = mouseX - this.f_97735_;
        int checkY = mouseY - this.f_97736_;
        if (this.outputTank != null) {
            this.outputTank.highlightHoveredFluid(graphics, checkX, checkY);
        }
        for (GuiTankModule tankModule : this.inputTanks) {
            tankModule.highlightHoveredFluid(graphics, checkX, checkY);
        }
        if (this.fuel != null) {
            this.fuel.renderHighlight(graphics, checkX, checkY);
        }
        assert (this.f_96541_ != null);
        SCALA.draw(graphics, 114, 16);
    }

    protected void m_280072_(GuiGraphics graphics, int mouseX, int mouseY) {
        super.m_280072_(graphics, mouseX, mouseY);
        if (this.outputTank != null) {
            this.outputTank.renderTooltip(graphics, mouseX, mouseY);
        }
        for (GuiTankModule tankModule : this.inputTanks) {
            tankModule.renderTooltip(graphics, mouseX, mouseY);
        }
        if (this.fuel != null) {
            this.fuel.addTooltip(graphics, mouseX, mouseY, true);
        }
    }

    @Override
    public IScreenWithFluidTank.FluidLocation getFluidUnderMouse(int mouseX, int mouseY) {
        IScreenWithFluidTank.FluidLocation ingredient;
        int checkX = mouseX - this.f_97735_;
        int checkY = mouseY - this.f_97736_;
        if (this.fuel != null && (ingredient = this.fuel.getFluidUnderMouse(checkX, checkY)) != null) {
            return ingredient;
        }
        if (this.outputTank != null && (ingredient = this.outputTank.getFluidUnderMouse(checkX, checkY)) != null) {
            return ingredient;
        }
        for (GuiTankModule tankModule : this.inputTanks) {
            IScreenWithFluidTank.FluidLocation ingredient2 = tankModule.getFluidUnderMouse(checkX, checkY);
            if (ingredient2 == null) continue;
            return ingredient2;
        }
        return null;
    }
}

