/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.alloying;

import java.util.BitSet;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.data.loadable.field.ContextKey;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.IntLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.recipe.ICustomOutputRecipe;
import slimeknights.mantle.recipe.helper.FluidOutput;
import slimeknights.mantle.recipe.ingredient.FluidIngredient;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.recipe.TinkerRecipeTypes;
import slimeknights.tconstruct.library.recipe.alloying.IAlloyTank;
import slimeknights.tconstruct.library.recipe.alloying.IMutableAlloyTank;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public class AlloyRecipe
implements ICustomOutputRecipe<IAlloyTank> {
    public static final RecordLoadable<AlloyRecipe> LOADER = RecordLoadable.create((RecordField)ContextKey.ID.requiredField(), (RecordField)FluidIngredient.LOADABLE.list(2).requiredField("inputs", r -> r.inputs), (RecordField)FluidOutput.Loadable.REQUIRED.requiredField("result", r -> r.output), (RecordField)IntLoadable.FROM_ONE.requiredField("temperature", r -> r.temperature), AlloyRecipe::new);
    private final ResourceLocation id;
    private final List<FluidIngredient> inputs;
    private final FluidOutput output;
    private final int temperature;
    private List<List<FluidStack>> displayInputs;

    public List<List<FluidStack>> getDisplayInputs() {
        if (this.displayInputs == null) {
            this.displayInputs = this.inputs.stream().map(FluidIngredient::getFluids).collect(Collectors.toList());
        }
        return this.displayInputs;
    }

    public FluidStack getOutput() {
        return this.output.get();
    }

    private static BitSet makeBitset(IAlloyTank inv) {
        int tanks = inv.getTanks();
        BitSet used = new BitSet(tanks);
        for (int i = 0; i < tanks; ++i) {
            if (!inv.getFluidInTank(i).isEmpty()) continue;
            used.set(i);
        }
        return used;
    }

    private static int findMatch(FluidIngredient ingredient, IAlloyTank inv, BitSet used, boolean checkSize) {
        for (int i = 0; i < inv.getTanks(); ++i) {
            if (used.get(i)) continue;
            FluidStack fluid = inv.getFluidInTank(i);
            if (!(checkSize ? ingredient.test(fluid) : ingredient.test(fluid.getFluid()))) continue;
            used.set(i);
            return i;
        }
        return -1;
    }

    public boolean matches(IAlloyTank inv, Level worldIn) {
        BitSet used = AlloyRecipe.makeBitset(inv);
        for (FluidIngredient ingredient : this.inputs) {
            int index = AlloyRecipe.findMatch(ingredient, inv, used, false);
            if (index != -1) continue;
            return false;
        }
        return true;
    }

    public boolean canPerform(IAlloyTank inv) {
        if (inv.getTemperature() < this.temperature) {
            return false;
        }
        BitSet used = AlloyRecipe.makeBitset(inv);
        int drainAmount = 0;
        for (FluidIngredient ingredient : this.inputs) {
            int index = AlloyRecipe.findMatch(ingredient, inv, used, true);
            if (index != -1) {
                FluidStack fluid = inv.getFluidInTank(index);
                drainAmount += ingredient.getAmount(fluid.getFluid());
                continue;
            }
            return false;
        }
        return inv.canFit(this.output.get(), drainAmount);
    }

    public void performRecipe(IMutableAlloyTank inv) {
        if (inv.getTemperature() < this.temperature) {
            return;
        }
        FluidStack[] drainFluids = new FluidStack[inv.getTanks()];
        int drainAmount = 0;
        BitSet used = AlloyRecipe.makeBitset(inv);
        for (FluidIngredient ingredient : this.inputs) {
            int index = AlloyRecipe.findMatch(ingredient, inv, used, true);
            if (index != -1 && drainFluids[index] == null) {
                FluidStack fluid = inv.getFluidInTank(index);
                int amount = ingredient.getAmount(fluid.getFluid());
                drainAmount += amount;
                drainFluids[index] = new FluidStack(fluid, amount);
                continue;
            }
            return;
        }
        if (inv.canFit(this.output.get(), drainAmount)) {
            for (int i = 0; i < drainFluids.length; ++i) {
                FluidStack drained;
                FluidStack toDrain = drainFluids[i];
                if (toDrain == null || (drained = inv.drain(i, toDrain)).getAmount() == toDrain.getAmount()) continue;
                TConstruct.LOG.error("Wrong amount of fluid {} drained for recipe {}", (Object)drained.getFluid(), (Object)this.id);
            }
            int filled = inv.fill(this.output.copy());
            if (filled != this.output.getAmount()) {
                TConstruct.LOG.error("Filled only {} for recipe {}", (Object)filled, (Object)this.id);
            }
        }
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)TinkerRecipeTypes.ALLOYING.get();
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TinkerSmeltery.alloyingSerializer.get();
    }

    public AlloyRecipe(ResourceLocation id, List<FluidIngredient> inputs, FluidOutput output, int temperature) {
        this.id = id;
        this.inputs = inputs;
        this.output = output;
        this.temperature = temperature;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public int getTemperature() {
        return this.temperature;
    }
}

