/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.melting;

import com.google.common.collect.Streams;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import slimeknights.mantle.data.loadable.field.ContextKey;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.recipe.helper.FluidOutput;
import slimeknights.mantle.recipe.helper.LoadableRecipeSerializer;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.json.TinkerLoadables;
import slimeknights.tconstruct.library.json.field.MergingListField;
import slimeknights.tconstruct.library.recipe.melting.IMeltingContainer;
import slimeknights.tconstruct.library.recipe.melting.MeltingRecipe;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public class OreMeltingRecipe
extends MeltingRecipe {
    public static final RecordLoadable<OreMeltingRecipe> LOADER = RecordLoadable.create((RecordField)ContextKey.ID.requiredField(), (RecordField)LoadableRecipeSerializer.RECIPE_GROUP, (RecordField)INPUT, (RecordField)OUTPUT, (RecordField)TEMPERATURE, (RecordField)TIME, (RecordField)BYPRODUCTS, (RecordField)TinkerLoadables.ORE_RATE_TYPE.requiredField("rate", OreMeltingRecipe::getOreType), new MergingListField(TinkerLoadables.ORE_RATE_TYPE.defaultField("rate", (Object)IMeltingContainer.OreRateType.DEFAULT, Function.identity()), "byproducts", r -> r.byproductTypes), OreMeltingRecipe::new);
    private final IMeltingContainer.OreRateType oreType;
    private final List<IMeltingContainer.OreRateType> byproductTypes;

    protected OreMeltingRecipe(ResourceLocation id, String group, Ingredient input, FluidOutput output, int temperature, int time, List<FluidOutput> byproducts, IMeltingContainer.OreRateType oreType, List<IMeltingContainer.OreRateType> byproductTypes) {
        super(id, group, input, output, temperature, time, byproducts);
        this.oreType = oreType;
        this.byproductTypes = byproductTypes;
    }

    @Override
    public FluidStack getOutput(IMeltingContainer inv) {
        return inv.getOreRate().applyOreBoost(this.oreType, this.output.get(), true);
    }

    @Override
    public void handleByproducts(IMeltingContainer inv, IFluidHandler handler) {
        for (int i = 0; i < this.byproducts.size(); ++i) {
            handler.fill(Config.COMMON.foundryByproductRate.applyOreBoost(this.byproductTypes.get(i).orElse(this.oreType), ((FluidOutput)this.byproducts.get(i)).get(), true), IFluidHandler.FluidAction.EXECUTE);
        }
    }

    @Override
    public List<List<FluidStack>> getOutputWithByproducts() {
        if (this.outputWithByproducts == null) {
            this.outputWithByproducts = Stream.concat(Stream.of(this.output).map(output -> Config.COMMON.foundryOreRate.applyOreBoost(this.oreType, output.get(), false)), Streams.zip(this.byproducts.stream(), this.byproductTypes.stream(), (byproduct, rate) -> Config.COMMON.foundryByproductRate.applyOreBoost(rate.orElse(this.oreType), byproduct.get(), false))).map(List::of).toList();
        }
        return this.outputWithByproducts;
    }

    @Override
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TinkerSmeltery.oreMeltingSerializer.get();
    }

    public static List<FluidStack> scaleByproducts(Config.OreRate rate, List<FluidStack> byproducts, IMeltingContainer.OreRateType rateType, List<IMeltingContainer.OreRateType> byproductRates) {
        if (byproductRates.isEmpty()) {
            return byproducts;
        }
        if (byproductRates.size() != byproducts.size()) {
            throw new IllegalArgumentException("Wrong number of byproduct rates passed, must have one per byproduct");
        }
        return Streams.zip(byproductRates.stream(), byproducts.stream(), (type, fluid) -> rate.applyOreBoost(type.orElse(rateType), (FluidStack)fluid, false)).toList();
    }

    @Override
    public IMeltingContainer.OreRateType getOreType() {
        return this.oreType;
    }
}

