/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.fuel;

import java.util.function.Consumer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.recipe.data.AbstractRecipeBuilder;
import slimeknights.mantle.recipe.ingredient.FluidIngredient;
import slimeknights.tconstruct.library.recipe.fuel.MeltingFuel;
import slimeknights.tconstruct.library.recipe.melting.IMeltingRecipe;

public class MeltingFuelBuilder
extends AbstractRecipeBuilder<MeltingFuelBuilder> {
    private final FluidIngredient input;
    private final int duration;
    private final int temperature;

    public static MeltingFuelBuilder fuel(FluidStack fluid, int duration) {
        return MeltingFuelBuilder.fuel(FluidIngredient.of((FluidStack)fluid), duration, IMeltingRecipe.getTemperature(fluid));
    }

    public void save(Consumer<FinishedRecipe> consumer) {
        if (this.input.getFluids().isEmpty()) {
            throw new IllegalStateException("Must have at least one fluid for dynamic input");
        }
        this.save(consumer, BuiltInRegistries.f_257020_.m_7981_((Object)((FluidStack)this.input.getFluids().get(0)).getFluid()));
    }

    public void save(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        ResourceLocation advancementId = this.buildOptionalAdvancement(id, "melting_fuel");
        consumer.accept((FinishedRecipe)new AbstractRecipeBuilder.LoadableFinishedRecipe((AbstractRecipeBuilder)this, (Recipe)new MeltingFuel(id, this.group, this.input, this.duration, this.temperature), MeltingFuel.LOADER, advancementId));
    }

    private MeltingFuelBuilder(FluidIngredient input, int duration, int temperature) {
        this.input = input;
        this.duration = duration;
        this.temperature = temperature;
    }

    public static MeltingFuelBuilder fuel(FluidIngredient input, int duration, int temperature) {
        return new MeltingFuelBuilder(input, duration, temperature);
    }
}

