/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.armor.texture;

import javax.annotation.Nullable;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import slimeknights.mantle.data.loadable.Loadables;
import slimeknights.mantle.data.loadable.common.ColorLoadable;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.StringLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.util.IdExtender;
import slimeknights.tconstruct.library.client.armor.texture.ArmorTextureSupplier;
import slimeknights.tconstruct.library.client.armor.texture.TintedArmorTexture;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;

public class FixedArmorTextureSupplier
implements ArmorTextureSupplier {
    public static final RecordLoadable<FixedArmorTextureSupplier> LOADER = RecordLoadable.create((RecordField)Loadables.RESOURCE_LOCATION.requiredField("prefix", s -> s.prefix), (RecordField)StringLoadable.DEFAULT.defaultField("suffix", (Object)"", s -> s.suffix), (RecordField)ColorLoadable.ALPHA.defaultField("color", (Object)-1, s -> s.color), (RecordField)ModifierId.PARSER.nullableField("modifier", s -> s.modifier), FixedArmorTextureSupplier::new);
    private final ResourceLocation prefix;
    private final String suffix;
    private final int color;
    @Nullable
    private final ModifierId modifier;
    private final TintedArmorTexture[] textures;

    public FixedArmorTextureSupplier(ResourceLocation prefix, String suffix, int color, @Nullable ModifierId modifier) {
        this.prefix = prefix;
        this.suffix = suffix;
        this.color = color;
        this.modifier = modifier;
        this.textures = new TintedArmorTexture[]{FixedArmorTextureSupplier.getTexture(prefix, "armor" + suffix, color), FixedArmorTextureSupplier.getTexture(prefix, "leggings" + suffix, color), FixedArmorTextureSupplier.getTexture(prefix, "wings" + suffix, color)};
    }

    @Nullable
    public static TintedArmorTexture getTexture(ResourceLocation base, String suffix, int color) {
        ResourceLocation name = base.m_266382_(suffix);
        if (TEXTURE_VALIDATOR.test(name)) {
            return new TintedArmorTexture(ArmorTextureSupplier.getTexturePath(name), color);
        }
        return null;
    }

    @Override
    public ArmorTextureSupplier.ArmorTexture getArmorTexture(ItemStack stack, ArmorTextureSupplier.TextureType textureType, RegistryAccess access) {
        TintedArmorTexture texture = this.textures[textureType.ordinal()];
        if (texture != null && (this.modifier == null || ModifierUtil.getModifierLevel(stack, this.modifier) > 0)) {
            return texture;
        }
        return ArmorTextureSupplier.ArmorTexture.EMPTY;
    }

    public RecordLoadable<FixedArmorTextureSupplier> getLoader() {
        return LOADER;
    }

    public static Builder builder(ResourceLocation base, String variant) {
        return new Builder(IdExtender.LocationExtender.INSTANCE.suffix(base, variant));
    }

    public static class Builder {
        private final ResourceLocation name;
        @Nullable
        private ModifierId modifier;
        private int color = -1;
        private String suffix = "";

        public Builder materialSuffix(MaterialVariantId id) {
            this.suffix = "_" + id.getSuffix();
            return this;
        }

        public FixedArmorTextureSupplier build() {
            return new FixedArmorTextureSupplier(this.name, this.suffix, this.color, this.modifier);
        }

        public Builder modifier(@Nullable ModifierId modifier) {
            this.modifier = modifier;
            return this;
        }

        public Builder color(int color) {
            this.color = color;
            return this;
        }

        public Builder suffix(String suffix) {
            this.suffix = suffix;
            return this;
        }

        private Builder(ResourceLocation name) {
            this.name = name;
        }
    }
}

