/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.recipe;

import javax.annotation.Nullable;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.recipe.RecipeResult;
import slimeknights.tconstruct.library.recipe.modifiers.adding.IModifierRecipe;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationContainer;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationRecipe;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.nbt.LazyToolStack;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.item.CreativeSlotItem;
import slimeknights.tconstruct.tools.modifiers.slotless.CreativeSlotModifier;

public class CreativeSlotRecipe
implements ITinkerStationRecipe,
IModifierRecipe {
    private final ResourceLocation id;

    @Nullable
    private SlotType findSlotType(ITinkerStationContainer inv, boolean stopAfterFirst) {
        SlotType type = null;
        for (int i = 0; i < inv.getInputCount(); ++i) {
            ItemStack stack = inv.getInput(i);
            if (stack.m_41619_()) continue;
            if (type != null || stack.m_41720_() != TinkerModifiers.creativeSlotItem.get()) {
                return null;
            }
            type = CreativeSlotItem.getSlot(stack);
            if (type == null) {
                return null;
            }
            if (!stopAfterFirst) continue;
            return type;
        }
        return type;
    }

    @Override
    public boolean matches(ITinkerStationContainer inv, Level world) {
        if (!inv.getTinkerableStack().m_204117_(TinkerTags.Items.MODIFIABLE)) {
            return false;
        }
        return this.findSlotType(inv, false) != null;
    }

    @Override
    public int shrinkToolSlotBy() {
        return 64;
    }

    @Override
    public RecipeResult<LazyToolStack> getValidatedResult(ITinkerStationContainer inv, RegistryAccess access) {
        ModifierId creative;
        CompoundTag slots;
        ToolStack toolStack = inv.getTinkerable().copy();
        ModDataNBT persistentData = toolStack.getPersistentData();
        if (persistentData.contains(CreativeSlotModifier.KEY_SLOTS, 10)) {
            slots = persistentData.getCompound(CreativeSlotModifier.KEY_SLOTS);
        } else {
            slots = new CompoundTag();
            persistentData.put(CreativeSlotModifier.KEY_SLOTS, (Tag)slots);
        }
        SlotType slotType = this.findSlotType(inv, true);
        if (slotType != null) {
            String name = slotType.getName();
            slots.m_128405_(name, slots.m_128451_(name) + 1);
        }
        if (toolStack.getModifierLevel(creative = TinkerModifiers.creativeSlot.getId()) == 0) {
            toolStack.addModifier(creative, 1);
        } else {
            toolStack.rebuildStats();
        }
        return LazyToolStack.success(toolStack, inv.getTinkerableSize());
    }

    @Override
    public Modifier getModifier() {
        return TinkerModifiers.creativeSlot.get();
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TinkerModifiers.creativeSlotSerializer.get();
    }

    public CreativeSlotRecipe(ResourceLocation id) {
        this.id = id;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }
}

