/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.modifiers.adding;

import com.google.common.collect.Streams;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import slimeknights.mantle.data.loadable.field.ContextKey;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.recipe.IMultiRecipe;
import slimeknights.mantle.recipe.ingredient.SizedIngredient;
import slimeknights.tconstruct.library.json.IntRange;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.recipe.RecipeResult;
import slimeknights.tconstruct.library.recipe.modifiers.adding.DisplayModifierRecipe;
import slimeknights.tconstruct.library.recipe.modifiers.adding.IDisplayModifierRecipe;
import slimeknights.tconstruct.library.recipe.modifiers.adding.ModifierRecipe;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationContainer;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.nbt.LazyToolStack;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class MultilevelModifierRecipe
extends ModifierRecipe
implements IMultiRecipe<IDisplayModifierRecipe> {
    public static final RecordLoadable<MultilevelModifierRecipe> LOADER = RecordLoadable.create((RecordField)ContextKey.ID.requiredField(), (RecordField)SizedIngredient.LOADABLE.list(0).defaultField("inputs", List.of(), r -> r.inputs), (RecordField)TOOLS_FIELD, (RecordField)MAX_TOOL_SIZE_FIELD, (RecordField)RESULT_FIELD, (RecordField)ALLOW_CRYSTAL_FIELD, (RecordField)LevelEntry.LOADABLE.list(1).requiredField("levels", r -> r.levels), (RecordField)CHECK_TRAIT_LEVEL_FIELD, MultilevelModifierRecipe::new).validate((recipe, error) -> {
        if (recipe.inputs.isEmpty() && !recipe.allowCrystal) {
            throw error.create("Must either have inputs or allow crystal");
        }
        return recipe;
    });
    private final List<LevelEntry> levels;
    private List<IDisplayModifierRecipe> displayRecipes = null;

    protected MultilevelModifierRecipe(ResourceLocation id, List<SizedIngredient> inputs, Ingredient toolRequirement, int maxToolSize, ModifierId result, boolean allowCrystal, List<LevelEntry> levels, boolean checkTraitLevel) {
        super(id, inputs, toolRequirement, maxToolSize, result, levels.get((int)0).level, levels.get(0).slots(), allowCrystal, checkTraitLevel);
        this.levels = levels;
    }

    @Override
    public RecipeResult<LazyToolStack> getValidatedResult(ITinkerStationContainer inv, RegistryAccess access) {
        ToolStack tool = inv.getTinkerable();
        int newLevel = (this.checkTraitLevel ? tool.getModifiers() : tool.getUpgrades()).getLevel(this.result.getId()) + 1;
        LevelEntry levelEntry = null;
        for (LevelEntry check : this.levels) {
            if (!check.matches(newLevel)) continue;
            levelEntry = check;
            break;
        }
        if (levelEntry == null) {
            int min = this.levels.get((int)0).level.min();
            if (newLevel < min) {
                return RecipeResult.failure(KEY_MIN_LEVEL, this.result.get().getDisplayName(min - 1));
            }
            return RecipeResult.failure(KEY_MAX_LEVEL, this.result.get().getDisplayName(), this.levels.get((int)(this.levels.size() - 1)).level.max());
        }
        SlotType.SlotCount slots = levelEntry.slots();
        Component requirements = MultilevelModifierRecipe.checkSlots(tool, slots);
        if (requirements != null) {
            return RecipeResult.failure(requirements);
        }
        tool = tool.copy();
        ModDataNBT persistentData = tool.getPersistentData();
        if (slots != null) {
            persistentData.addSlots(slots.type(), -slots.count());
        }
        tool.addModifier(this.result.getId(), 1);
        Component toolValidation = tool.tryValidate();
        if (toolValidation != null) {
            return RecipeResult.failure(toolValidation);
        }
        return this.success(tool, inv);
    }

    @Override
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TinkerModifiers.multilevelModifierSerializer.get();
    }

    public List<IDisplayModifierRecipe> getRecipes(RegistryAccess access) {
        if (this.inputs.isEmpty()) {
            return Collections.emptyList();
        }
        if (this.displayRecipes == null) {
            List<ItemStack> toolWithoutModifier = this.getToolWithoutModifier();
            List<ItemStack> toolWithModifier = this.getToolWithModifier();
            ModifierEntry result = this.getDisplayResult();
            this.displayRecipes = Streams.concat((Stream[])new Stream[]{Stream.of(this), this.levels.stream().skip(1L).map(levelEntry -> new DisplayModifierRecipe(this.inputs, toolWithoutModifier, toolWithModifier, result, levelEntry.level, levelEntry.slots))}).toList();
        }
        return this.displayRecipes;
    }

    record LevelEntry(@Nullable SlotType.SlotCount slots, IntRange level) {
        public static final RecordLoadable<LevelEntry> LOADABLE = RecordLoadable.create((RecordField)SlotType.SlotCount.LOADABLE.nullableField("slots", LevelEntry::slots), (RecordField)ModifierEntry.VALID_LEVEL.requiredField("level", LevelEntry::level), LevelEntry::new);

        public boolean matches(int level) {
            return this.level.test(level);
        }
    }
}

