/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tables.recipe;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import slimeknights.mantle.data.loadable.common.IngredientLoadable;
import slimeknights.mantle.data.loadable.field.ContextKey;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.IntLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.recipe.RecipeResult;
import slimeknights.tconstruct.library.recipe.modifiers.adding.IncrementalModifierRecipe;
import slimeknights.tconstruct.library.recipe.tinkerstation.IMutableTinkerStationContainer;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationContainer;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationRecipe;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.tables.TinkerTables;

public class TinkerStationDamagingRecipe
implements ITinkerStationRecipe {
    public static final RecordLoadable<TinkerStationDamagingRecipe> LOADER = RecordLoadable.create((RecordField)ContextKey.ID.requiredField(), (RecordField)IngredientLoadable.DISALLOW_EMPTY.requiredField("ingredient", r -> r.ingredient), (RecordField)IntLoadable.FROM_ONE.requiredField("damage_amount", r -> r.damageAmount), TinkerStationDamagingRecipe::new);
    private static final RecipeResult<ItemStack> BROKEN = RecipeResult.failure(TConstruct.makeTranslationKey("recipe", "damaging.broken"), new Object[0]);
    private final ResourceLocation id;
    private final Ingredient ingredient;
    private final int damageAmount;

    @Override
    public boolean matches(ITinkerStationContainer inv, Level world) {
        if (!inv.getTinkerableStack().m_204117_(TinkerTags.Items.DURABILITY)) {
            return false;
        }
        return IncrementalModifierRecipe.containsOnlyIngredient(inv, this.ingredient);
    }

    @Override
    public RecipeResult<ItemStack> getValidatedResult(ITinkerStationContainer inv) {
        ToolStack tool = inv.getTinkerable();
        if (tool.isBroken()) {
            return BROKEN;
        }
        tool = tool.copy();
        int maxDamage = IncrementalModifierRecipe.getAvailableAmount(inv, this.ingredient, this.damageAmount);
        ToolDamageUtil.directDamage(tool, maxDamage, null, inv.getTinkerableStack());
        return RecipeResult.success(tool.createStack());
    }

    @Override
    public int shrinkToolSlotBy() {
        return 1;
    }

    @Override
    public void updateInputs(ItemStack result, IMutableTinkerStationContainer inv, boolean isServer) {
        int damageTaken = ToolStack.from(result).getDamage() - inv.getTinkerable().getDamage();
        IncrementalModifierRecipe.updateInputs(inv, this.ingredient, damageTaken, this.damageAmount, ItemStack.f_41583_);
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TinkerTables.tinkerStationDamagingSerializer.get();
    }

    public TinkerStationDamagingRecipe(ResourceLocation id, Ingredient ingredient, int damageAmount) {
        this.id = id;
        this.ingredient = ingredient;
        this.damageAmount = damageAmount;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }
}

