/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tables;

import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.RegistryObject;
import slimeknights.mantle.recipe.helper.LoadableRecipeSerializer;
import slimeknights.mantle.recipe.helper.SimpleRecipeSerializer;
import slimeknights.mantle.registration.object.ItemObject;
import slimeknights.mantle.util.RetexturedHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerModule;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.recipe.material.MaterialRecipe;
import slimeknights.tconstruct.library.recipe.partbuilder.ItemPartRecipe;
import slimeknights.tconstruct.library.recipe.partbuilder.PartRecipe;
import slimeknights.tconstruct.library.recipe.tinkerstation.building.ToolBuildingRecipe;
import slimeknights.tconstruct.library.tools.layout.StationSlotLayoutLoader;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.shared.block.TableBlock;
import slimeknights.tconstruct.tables.block.ChestBlock;
import slimeknights.tconstruct.tables.block.CraftingStationBlock;
import slimeknights.tconstruct.tables.block.GenericTableBlock;
import slimeknights.tconstruct.tables.block.ScorchedAnvilBlock;
import slimeknights.tconstruct.tables.block.TinkerStationBlock;
import slimeknights.tconstruct.tables.block.TinkersAnvilBlock;
import slimeknights.tconstruct.tables.block.TinkersChestBlock;
import slimeknights.tconstruct.tables.block.entity.chest.CastChestBlockEntity;
import slimeknights.tconstruct.tables.block.entity.chest.PartChestBlockEntity;
import slimeknights.tconstruct.tables.block.entity.chest.TinkersChestBlockEntity;
import slimeknights.tconstruct.tables.block.entity.table.CraftingStationBlockEntity;
import slimeknights.tconstruct.tables.block.entity.table.ModifierWorktableBlockEntity;
import slimeknights.tconstruct.tables.block.entity.table.PartBuilderBlockEntity;
import slimeknights.tconstruct.tables.block.entity.table.TinkerStationBlockEntity;
import slimeknights.tconstruct.tables.data.TableRecipeProvider;
import slimeknights.tconstruct.tables.item.TinkersChestBlockItem;
import slimeknights.tconstruct.tables.menu.CraftingStationContainerMenu;
import slimeknights.tconstruct.tables.menu.ModifierWorktableContainerMenu;
import slimeknights.tconstruct.tables.menu.PartBuilderContainerMenu;
import slimeknights.tconstruct.tables.menu.TinkerChestContainerMenu;
import slimeknights.tconstruct.tables.menu.TinkerStationContainerMenu;
import slimeknights.tconstruct.tables.recipe.CraftingTableRepairKitRecipe;
import slimeknights.tconstruct.tables.recipe.PartBuilderToolRecycle;
import slimeknights.tconstruct.tables.recipe.TinkerStationDamagingRecipe;
import slimeknights.tconstruct.tables.recipe.TinkerStationPartSwapping;
import slimeknights.tconstruct.tables.recipe.TinkerStationRepairRecipe;

public final class TinkerTables
extends TinkerModule {
    public static final RegistryObject<CreativeModeTab> tabTables = CREATIVE_TABS.register("tables", () -> CreativeModeTab.builder().m_257941_((Component)TConstruct.makeTranslation("itemGroup", "tables")).m_257737_(() -> new ItemStack(craftingStation)).m_257501_(TinkerTables::addTabItems).withTabsBefore(new ResourceLocation[]{TinkerCommons.tabGeneral.getId()}).m_257652_());
    public static final ItemObject<TableBlock> craftingStation;
    public static final ItemObject<TableBlock> tinkerStation;
    public static final ItemObject<TableBlock> partBuilder;
    public static final ItemObject<TableBlock> tinkersChest;
    public static final ItemObject<TableBlock> partChest;
    public static final ItemObject<TableBlock> castChest;
    public static final ItemObject<TableBlock> modifierWorktable;
    public static final ItemObject<TableBlock> tinkersAnvil;
    public static final ItemObject<TableBlock> scorchedAnvil;
    public static final ItemObject<Item> pattern;
    public static final RegistryObject<BlockEntityType<CraftingStationBlockEntity>> craftingStationTile;
    public static final RegistryObject<BlockEntityType<TinkerStationBlockEntity>> tinkerStationTile;
    public static final RegistryObject<BlockEntityType<PartBuilderBlockEntity>> partBuilderTile;
    public static final RegistryObject<BlockEntityType<ModifierWorktableBlockEntity>> modifierWorktableTile;
    public static final RegistryObject<BlockEntityType<TinkersChestBlockEntity>> tinkersChestTile;
    public static final RegistryObject<BlockEntityType<PartChestBlockEntity>> partChestTile;
    public static final RegistryObject<BlockEntityType<CastChestBlockEntity>> castChestTile;
    public static final RegistryObject<MenuType<CraftingStationContainerMenu>> craftingStationContainer;
    public static final RegistryObject<MenuType<TinkerStationContainerMenu>> tinkerStationContainer;
    public static final RegistryObject<MenuType<PartBuilderContainerMenu>> partBuilderContainer;
    public static final RegistryObject<MenuType<ModifierWorktableContainerMenu>> modifierWorktableContainer;
    public static final RegistryObject<MenuType<TinkerChestContainerMenu>> tinkerChestContainer;
    public static final RegistryObject<RecipeSerializer<MaterialRecipe>> materialRecipeSerializer;
    public static final RegistryObject<RecipeSerializer<ToolBuildingRecipe>> toolBuildingRecipeSerializer;
    public static final RegistryObject<SimpleRecipeSerializer<TinkerStationPartSwapping>> tinkerStationPartSwappingSerializer;
    public static final RegistryObject<RecipeSerializer<TinkerStationDamagingRecipe>> tinkerStationDamagingSerializer;
    public static final RegistryObject<RecipeSerializer<PartRecipe>> partRecipeSerializer;
    public static final RegistryObject<RecipeSerializer<ItemPartRecipe>> itemPartBuilderSerializer;
    public static final RegistryObject<RecipeSerializer<PartBuilderToolRecycle>> partBuilderToolRecycling;
    public static final RegistryObject<SimpleRecipeSerializer<TinkerStationRepairRecipe>> tinkerStationRepairSerializer;
    public static final RegistryObject<SimpleRecipeSerializer<CraftingTableRepairKitRecipe>> craftingTableRepairSerializer;

    @SubscribeEvent
    void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            StationSlotLayoutLoader loader = StationSlotLayoutLoader.getInstance();
            loader.registerRequiredLayout(tinkerStation.getId());
            loader.registerRequiredLayout(tinkersAnvil.getId());
            loader.registerRequiredLayout(scorchedAnvil.getId());
        });
    }

    @SubscribeEvent
    void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        generator.addProvider(event.includeServer(), (DataProvider)new TableRecipeProvider(generator.getPackOutput()));
    }

    private static void addTabItems(CreativeModeTab.ItemDisplayParameters itemDisplayParameters, CreativeModeTab.Output output) {
        output.m_246326_(pattern);
        output.m_246326_(craftingStation);
        output.m_246326_(partBuilder);
        output.m_246326_(tinkerStation);
        CreativeModeTab.TabVisibility firstAnvilVisibility = (Boolean)Config.COMMON.showAllAnvilVariants.get() != false ? CreativeModeTab.TabVisibility.PARENT_TAB_ONLY : CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS;
        output.m_245282_(tinkersAnvil, firstAnvilVisibility);
        output.m_245282_(scorchedAnvil, firstAnvilVisibility);
        output.m_246326_(modifierWorktable);
        output.m_246326_(tinkersChest);
        output.m_246326_(partChest);
        output.m_246326_(castChest);
        CreativeModeTab.TabVisibility woodVisibility = (Boolean)Config.COMMON.showAllTableVariants.get() != false ? CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS : CreativeModeTab.TabVisibility.PARENT_TAB_ONLY;
        RetexturedHelper.addTagVariants((CreativeModeTab.Output)output, craftingStation, (TagKey)ItemTags.f_13182_, (CreativeModeTab.TabVisibility)woodVisibility, (CreativeModeTab.TabVisibility)woodVisibility);
        RetexturedHelper.addTagVariants((CreativeModeTab.Output)output, partBuilder, (TagKey)ItemTags.f_13168_, (CreativeModeTab.TabVisibility)woodVisibility, (CreativeModeTab.TabVisibility)woodVisibility);
        RetexturedHelper.addTagVariants((CreativeModeTab.Output)output, tinkerStation, (TagKey)ItemTags.f_13168_, (CreativeModeTab.TabVisibility)woodVisibility, (CreativeModeTab.TabVisibility)woodVisibility);
        CreativeModeTab.TabVisibility anvilVisibility = (Boolean)Config.COMMON.showAllAnvilVariants.get() != false ? CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS : CreativeModeTab.TabVisibility.PARENT_TAB_ONLY;
        RetexturedHelper.addTagVariants((CreativeModeTab.Output)output, tinkersAnvil, TinkerTags.Items.ANVIL_METAL, (CreativeModeTab.TabVisibility)anvilVisibility, (CreativeModeTab.TabVisibility)anvilVisibility);
        RetexturedHelper.addTagVariants((CreativeModeTab.Output)output, scorchedAnvil, TinkerTags.Items.ANVIL_METAL, (CreativeModeTab.TabVisibility)anvilVisibility, (CreativeModeTab.TabVisibility)anvilVisibility);
        RetexturedHelper.addTagVariants((CreativeModeTab.Output)output, modifierWorktable, TinkerTags.Items.WORKSTATION_ROCK, (CreativeModeTab.TabVisibility)woodVisibility, (CreativeModeTab.TabVisibility)woodVisibility);
    }

    static {
        BlockBehaviour.Properties WOOD_TABLE = TinkerTables.builder(MapColor.f_283825_, SoundType.f_56736_).m_280658_(NoteBlockInstrument.BASS).m_60913_(1.0f, 5.0f).m_60955_();
        craftingStation = BLOCKS.register("crafting_station", () -> new CraftingStationBlock(WOOD_TABLE), BLOCK_ITEM);
        tinkerStation = BLOCKS.register("tinker_station", () -> new TinkerStationBlock(WOOD_TABLE, 4), BLOCK_ITEM);
        partBuilder = BLOCKS.register("part_builder", () -> new GenericTableBlock(WOOD_TABLE, (BlockEntityType.BlockEntitySupplier<? extends BlockEntity>)((BlockEntityType.BlockEntitySupplier)PartBuilderBlockEntity::new)), BLOCK_ITEM);
        tinkersChest = BLOCKS.register("tinkers_chest", () -> new TinkersChestBlock(WOOD_TABLE, (BlockEntityType.BlockEntitySupplier<? extends BlockEntity>)((BlockEntityType.BlockEntitySupplier)TinkersChestBlockEntity::new), true), block -> new TinkersChestBlockItem((Block)block, ITEM_PROPS));
        partChest = BLOCKS.register("part_chest", () -> new ChestBlock(WOOD_TABLE, (BlockEntityType.BlockEntitySupplier<? extends BlockEntity>)((BlockEntityType.BlockEntitySupplier)PartChestBlockEntity::new), true), BLOCK_ITEM);
        BlockBehaviour.Properties STONE_TABLE = TinkerTables.builder(MapColor.f_283818_, SoundType.f_56743_).m_280658_(NoteBlockInstrument.BASEDRUM).m_60999_().m_60913_(3.0f, 9.0f).m_60955_();
        castChest = BLOCKS.register("cast_chest", () -> new ChestBlock(STONE_TABLE, (BlockEntityType.BlockEntitySupplier<? extends BlockEntity>)((BlockEntityType.BlockEntitySupplier)CastChestBlockEntity::new), false), BLOCK_ITEM);
        modifierWorktable = BLOCKS.register("modifier_worktable", () -> new GenericTableBlock(STONE_TABLE, (BlockEntityType.BlockEntitySupplier<? extends BlockEntity>)((BlockEntityType.BlockEntitySupplier)ModifierWorktableBlockEntity::new)), BLOCK_ITEM);
        BlockBehaviour.Properties METAL_TABLE = TinkerTables.builder(MapColor.f_283818_, SoundType.f_56749_).m_278166_(PushReaction.BLOCK).m_60999_().m_60913_(5.0f, 1200.0f).m_60955_();
        tinkersAnvil = BLOCKS.register("tinkers_anvil", () -> new TinkersAnvilBlock(METAL_TABLE, 6), BLOCK_ITEM);
        scorchedAnvil = BLOCKS.register("scorched_anvil", () -> new ScorchedAnvilBlock(METAL_TABLE, 6), BLOCK_ITEM);
        pattern = ITEMS.register("pattern", ITEM_PROPS);
        craftingStationTile = BLOCK_ENTITIES.register("crafting_station", CraftingStationBlockEntity::new, craftingStation);
        tinkerStationTile = BLOCK_ENTITIES.register("tinker_station", TinkerStationBlockEntity::new, builder -> builder.add((Object[])new Block[]{(Block)tinkerStation.get(), (Block)tinkersAnvil.get(), (Block)scorchedAnvil.get()}));
        partBuilderTile = BLOCK_ENTITIES.register("part_builder", PartBuilderBlockEntity::new, partBuilder);
        modifierWorktableTile = BLOCK_ENTITIES.register("modifier_worktable", ModifierWorktableBlockEntity::new, modifierWorktable);
        tinkersChestTile = BLOCK_ENTITIES.register("modifier_chest", TinkersChestBlockEntity::new, tinkersChest);
        partChestTile = BLOCK_ENTITIES.register("part_chest", PartChestBlockEntity::new, partChest);
        castChestTile = BLOCK_ENTITIES.register("cast_chest", CastChestBlockEntity::new, castChest);
        craftingStationContainer = MENUS.register("crafting_station", CraftingStationContainerMenu::new);
        tinkerStationContainer = MENUS.register("tinker_station", TinkerStationContainerMenu::new);
        partBuilderContainer = MENUS.register("part_builder", PartBuilderContainerMenu::new);
        modifierWorktableContainer = MENUS.register("modifier_worktable", ModifierWorktableContainerMenu::new);
        tinkerChestContainer = MENUS.register("tinker_chest", TinkerChestContainerMenu::new);
        materialRecipeSerializer = RECIPE_SERIALIZERS.register("material", () -> LoadableRecipeSerializer.of(MaterialRecipe.LOADER));
        toolBuildingRecipeSerializer = RECIPE_SERIALIZERS.register("tool_building", () -> LoadableRecipeSerializer.of(ToolBuildingRecipe.LOADER));
        tinkerStationPartSwappingSerializer = RECIPE_SERIALIZERS.register("tinker_station_part_swapping", () -> new SimpleRecipeSerializer(TinkerStationPartSwapping::new));
        tinkerStationDamagingSerializer = RECIPE_SERIALIZERS.register("tinker_station_damaging", () -> LoadableRecipeSerializer.of(TinkerStationDamagingRecipe.LOADER));
        partRecipeSerializer = RECIPE_SERIALIZERS.register("part_builder", () -> LoadableRecipeSerializer.of(PartRecipe.LOADER));
        itemPartBuilderSerializer = RECIPE_SERIALIZERS.register("item_part_builder", () -> LoadableRecipeSerializer.of(ItemPartRecipe.LOADER));
        partBuilderToolRecycling = RECIPE_SERIALIZERS.register("part_builder_tool_recycling", () -> LoadableRecipeSerializer.of(PartBuilderToolRecycle.LOADER));
        tinkerStationRepairSerializer = RECIPE_SERIALIZERS.register("tinker_station_repair", () -> new SimpleRecipeSerializer(TinkerStationRepairRecipe::new));
        craftingTableRepairSerializer = RECIPE_SERIALIZERS.register("crafting_table_repair", () -> new SimpleRecipeSerializer(CraftingTableRepairKitRecipe::new));
    }
}

