/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.shared;

import com.google.gson.JsonDeserializer;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RecipesUpdatedEvent;
import net.minecraftforge.client.event.RenderBlockScreenEffectEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Matrix4f;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.common.recipe.RecipeCacheInvalidator;
import slimeknights.tconstruct.library.client.armor.texture.ArmorTextureSupplier;
import slimeknights.tconstruct.library.client.armor.texture.DyedArmorTextureSupplier;
import slimeknights.tconstruct.library.client.armor.texture.FirstArmorTextureSupplier;
import slimeknights.tconstruct.library.client.armor.texture.FixedArmorTextureSupplier;
import slimeknights.tconstruct.library.client.armor.texture.MaterialArmorTextureSupplier;
import slimeknights.tconstruct.library.client.book.TinkerBook;
import slimeknights.tconstruct.library.client.data.spritetransformer.GreyToColorMapping;
import slimeknights.tconstruct.library.client.data.spritetransformer.GreyToSpriteTransformer;
import slimeknights.tconstruct.library.client.data.spritetransformer.IColorMapping;
import slimeknights.tconstruct.library.client.data.spritetransformer.ISpriteTransformer;
import slimeknights.tconstruct.library.client.data.spritetransformer.OffsettingSpriteTransformer;
import slimeknights.tconstruct.library.client.data.spritetransformer.RecolorSpriteTransformer;
import slimeknights.tconstruct.library.client.materials.MaterialRenderInfoLoader;
import slimeknights.tconstruct.library.client.modifiers.ModifierIconManager;

@Mod.EventBusSubscriber(modid="tconstruct", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class TinkerClient {
    public static void onConstruct() {
        TinkerBook.initBook();
        ModifierIconManager.init();
        MaterialRenderInfoLoader.init();
        Consumer<RecipesUpdatedEvent> recipesUpdated = event -> RecipeCacheInvalidator.reload(true);
        MinecraftForge.EVENT_BUS.addListener(recipesUpdated);
        ISpriteTransformer.SERIALIZER.registerDeserializer(RecolorSpriteTransformer.NAME, (JsonDeserializer)RecolorSpriteTransformer.DESERIALIZER);
        GreyToSpriteTransformer.init();
        ISpriteTransformer.SERIALIZER.registerDeserializer(OffsettingSpriteTransformer.NAME, OffsettingSpriteTransformer.DESERIALIZER);
        IColorMapping.SERIALIZER.registerDeserializer(GreyToColorMapping.NAME, (JsonDeserializer)GreyToColorMapping.DESERIALIZER);
        ArmorTextureSupplier.LOADER.register(TConstruct.getResource("fixed"), FixedArmorTextureSupplier.LOADER);
        ArmorTextureSupplier.LOADER.register(TConstruct.getResource("dyed"), DyedArmorTextureSupplier.LOADER);
        ArmorTextureSupplier.LOADER.register(TConstruct.getResource("first_present"), FirstArmorTextureSupplier.LOADER);
        ArmorTextureSupplier.LOADER.register(TConstruct.getResource("material"), MaterialArmorTextureSupplier.Material.LOADER);
        ArmorTextureSupplier.LOADER.register(TConstruct.getResource("persistent_data"), MaterialArmorTextureSupplier.PersistentData.LOADER);
    }

    @SubscribeEvent
    static void renderBlockOverlay(RenderBlockScreenEffectEvent event) {
        BlockState state = event.getBlockState();
        if (state.m_204336_(TinkerTags.Blocks.TRANSPARENT_OVERLAY)) {
            Minecraft minecraft = Minecraft.m_91087_();
            assert (minecraft.f_91073_ != null);
            assert (minecraft.f_91074_ != null);
            BlockPos pos = event.getBlockPos();
            float width = minecraft.f_91074_.m_20205_() * 0.8f;
            if (Shapes.m_83157_((VoxelShape)state.m_60808_((BlockGetter)minecraft.f_91073_, pos).m_83216_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()), (VoxelShape)Shapes.m_83064_((AABB)AABB.m_165882_((Vec3)minecraft.f_91074_.m_146892_(), (double)width, (double)1.0E-6, (double)width)), (BooleanOp)BooleanOp.f_82689_)) {
                TextureAtlasSprite texture = minecraft.m_91289_().m_110907_().getTexture(state, (Level)minecraft.f_91073_, pos);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture.m_247685_());
                RenderSystem.setShader(GameRenderer::m_172817_);
                BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
                LocalPlayer player = minecraft.f_91074_;
                BlockPos blockpos = BlockPos.m_274561_((double)player.m_20185_(), (double)player.m_20188_(), (double)player.m_20189_());
                float brightness = LightTexture.m_234316_((DimensionType)player.m_9236_().m_6042_(), (int)player.m_9236_().m_46803_(blockpos));
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                RenderSystem.setShaderColor((float)brightness, (float)brightness, (float)brightness, (float)1.0f);
                float u0 = texture.m_118409_();
                float u1 = texture.m_118410_();
                float v0 = texture.m_118411_();
                float v1 = texture.m_118412_();
                Matrix4f matrix4f = event.getPoseStack().m_85850_().m_252922_();
                bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
                bufferbuilder.m_252986_(matrix4f, -1.0f, -1.0f, -0.5f).m_7421_(u1, v1).m_5752_();
                bufferbuilder.m_252986_(matrix4f, 1.0f, -1.0f, -0.5f).m_7421_(u0, v1).m_5752_();
                bufferbuilder.m_252986_(matrix4f, 1.0f, 1.0f, -0.5f).m_7421_(u0, v0).m_5752_();
                bufferbuilder.m_252986_(matrix4f, -1.0f, 1.0f, -0.5f).m_7421_(u1, v0).m_5752_();
                BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
                RenderSystem.disableBlend();
            }
            event.setCanceled(true);
        }
    }
}

