/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.partbuilder;

import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import slimeknights.mantle.data.loadable.common.IngredientLoadable;
import slimeknights.mantle.data.loadable.field.ContextKey;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.IntLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.recipe.IMultiRecipe;
import slimeknights.mantle.recipe.helper.ItemOutput;
import slimeknights.mantle.recipe.helper.LoadableRecipeSerializer;
import slimeknights.tconstruct.library.json.TinkerLoadables;
import slimeknights.tconstruct.library.json.field.MergingField;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.definition.MaterialVariant;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.recipe.material.IMaterialValue;
import slimeknights.tconstruct.library.recipe.partbuilder.IPartBuilderContainer;
import slimeknights.tconstruct.library.recipe.partbuilder.IPartBuilderRecipe;
import slimeknights.tconstruct.library.recipe.partbuilder.ItemPartRecipe;
import slimeknights.tconstruct.library.recipe.partbuilder.Pattern;
import slimeknights.tconstruct.library.tools.part.IMaterialItem;
import slimeknights.tconstruct.tables.TinkerTables;

public class PartRecipe
implements IPartBuilderRecipe,
IMultiRecipe<ItemPartRecipe> {
    public static final RecordLoadable<PartRecipe> LOADER = RecordLoadable.create((RecordField)ContextKey.ID.requiredField(), (RecordField)LoadableRecipeSerializer.RECIPE_GROUP, (RecordField)Pattern.PARSER.requiredField("pattern", PartRecipe::getPattern), (RecordField)IngredientLoadable.DISALLOW_EMPTY.defaultField("pattern_item", (Object)DEFAULT_PATTERNS, r -> r.patternItem), (RecordField)IntLoadable.FROM_ONE.requiredField("cost", PartRecipe::getCost), new MergingField(TinkerLoadables.MATERIAL_ITEM.requiredField("item", r -> r.output), "result", MergingField.MissingMode.DISALLOWED), new MergingField(IntLoadable.FROM_ONE.defaultField("count", (Object)1, r -> r.outputCount), "result", MergingField.MissingMode.CREATE), PartRecipe::new);
    protected final ResourceLocation id;
    protected final String group;
    protected final Pattern pattern;
    protected final Ingredient patternItem;
    protected final int cost;
    protected final IMaterialItem output;
    protected final int outputCount;
    @Nullable
    private List<ItemPartRecipe> multiRecipes;

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TinkerTables.partRecipeSerializer.get();
    }

    @Override
    public boolean partialMatch(IPartBuilderContainer inv) {
        if (!this.patternItem.test(inv.getPatternStack())) {
            return false;
        }
        ItemStack stack = inv.getStack();
        if (!stack.m_41619_()) {
            if (stack.m_41720_() == this.output) {
                return false;
            }
            IMaterialValue materialRecipe = inv.getMaterial();
            if (materialRecipe == null) {
                return false;
            }
            MaterialVariant material = materialRecipe.getMaterial();
            return material.get().isCraftable() && this.output.canUseMaterial(material.getId());
        }
        return true;
    }

    public boolean matches(IPartBuilderContainer inv, Level world) {
        IMaterialValue materialRecipe = inv.getMaterial();
        if (materialRecipe != null) {
            MaterialVariant material = materialRecipe.getMaterial();
            return material.get().isCraftable() && this.output.canUseMaterial(material.getId()) && inv.getStack().m_41613_() >= materialRecipe.getItemsUsed(this.cost);
        }
        return false;
    }

    @Deprecated
    public ItemStack m_8043_(RegistryAccess access) {
        return new ItemStack((ItemLike)this.output);
    }

    public ItemStack getRecipeOutput(MaterialVariantId material) {
        ItemStack stack = this.output.withMaterial(material);
        stack.m_41764_(this.outputCount);
        return stack;
    }

    public ItemStack assemble(IPartBuilderContainer inv, RegistryAccess access) {
        MaterialVariant material = MaterialVariant.UNKNOWN;
        IMaterialValue materialRecipe = inv.getMaterial();
        if (materialRecipe != null) {
            material = materialRecipe.getMaterial();
        }
        return this.getRecipeOutput(material.getVariant());
    }

    public List<ItemPartRecipe> getRecipes() {
        if (this.multiRecipes == null) {
            this.multiRecipes = MaterialRegistry.getMaterials().stream().filter(mat -> mat.isCraftable() && this.output.canUseMaterial((IMaterial)mat)).map(mat -> {
                MaterialId materialId = mat.getIdentifier();
                return new ItemPartRecipe(materialId, mat.getIdentifier(), this.pattern, this.patternItem, this.getCost(), ItemOutput.fromStack((ItemStack)this.output.withMaterial(materialId)));
            }).collect(Collectors.toList());
        }
        return this.multiRecipes;
    }

    public PartRecipe(ResourceLocation id, String group, Pattern pattern, Ingredient patternItem, int cost, IMaterialItem output, int outputCount) {
        this.id = id;
        this.group = group;
        this.pattern = pattern;
        this.patternItem = patternItem;
        this.cost = cost;
        this.output = output;
        this.outputCount = outputCount;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public String m_6076_() {
        return this.group;
    }

    @Override
    public Pattern getPattern() {
        return this.pattern;
    }

    @Override
    public int getCost() {
        return this.cost;
    }
}

