/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.events;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import slimeknights.tconstruct.library.modifiers.hook.interaction.InteractionSource;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public abstract class TinkerToolEvent
extends Event {
    private final ItemStack stack;
    private final IToolStackView tool;

    public TinkerToolEvent(ItemStack stack) {
        this.stack = stack;
        this.tool = ToolStack.from(stack);
    }

    public TinkerToolEvent(ItemStack stack, IToolStackView tool) {
        this.stack = stack;
        this.tool = tool;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public IToolStackView getTool() {
        return this.tool;
    }

    @Event.HasResult
    public static class ToolShearEvent
    extends TinkerToolEvent {
        private final Level world;
        private final Player player;
        private final Entity target;
        private final int fortune;

        public ToolShearEvent(ItemStack stack, IToolStackView tool, Level world, Player player, Entity target, int fortune) {
            super(stack, tool);
            this.world = world;
            this.player = player;
            this.target = target;
            this.fortune = fortune;
        }

        public Event.Result fire() {
            MinecraftForge.EVENT_BUS.post((Event)this);
            return this.getResult();
        }

        public Level getWorld() {
            return this.world;
        }

        public Player getPlayer() {
            return this.player;
        }

        public Entity getTarget() {
            return this.target;
        }

        public int getFortune() {
            return this.fortune;
        }
    }

    @Event.HasResult
    public static class ToolHarvestEvent
    extends TinkerToolEvent {
        private final UseOnContext context;
        private final ServerLevel world;
        private final BlockState state;
        private final BlockPos pos;
        private final InteractionSource source;

        public ToolHarvestEvent(IToolStackView tool, UseOnContext context, ServerLevel world, BlockState state, BlockPos pos, InteractionSource source) {
            super(ToolHarvestEvent.getItem(context, source), tool);
            this.context = context;
            this.world = world;
            this.state = state;
            this.pos = pos;
            this.source = source;
        }

        private static ItemStack getItem(UseOnContext context, InteractionSource source) {
            Player player = context.m_43723_();
            if (player != null) {
                return player.m_6844_(source.getSlot(context.m_43724_()));
            }
            return context.m_43722_();
        }

        private static ItemStack getItem(UseOnContext context, EquipmentSlot slotType) {
            Player player = context.m_43723_();
            if (player != null) {
                return player.m_6844_(slotType);
            }
            return context.m_43722_();
        }

        @Nullable
        public Player getPlayer() {
            return this.context.m_43723_();
        }

        public Event.Result fire() {
            MinecraftForge.EVENT_BUS.post((Event)this);
            return this.getResult();
        }

        public UseOnContext getContext() {
            return this.context;
        }

        public ServerLevel getWorld() {
            return this.world;
        }

        public BlockState getState() {
            return this.state;
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public InteractionSource getSource() {
            return this.source;
        }
    }
}

