/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.data.tinkering;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.data.GenericDataProvider;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.mantle.data.predicate.entity.LivingEntityPredicate;
import slimeknights.mantle.recipe.ingredient.FluidIngredient;
import slimeknights.mantle.registration.object.FluidObject;
import slimeknights.tconstruct.common.TinkerDamageTypes;
import slimeknights.tconstruct.library.modifiers.fluid.ConditionalFluidEffect;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffect;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffectContext;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffects;
import slimeknights.tconstruct.library.modifiers.fluid.FluidMobEffect;
import slimeknights.tconstruct.library.modifiers.fluid.TimeAction;
import slimeknights.tconstruct.library.modifiers.fluid.block.PlaceBlockFluidEffect;
import slimeknights.tconstruct.library.modifiers.fluid.entity.DamageFluidEffect;
import slimeknights.tconstruct.library.modifiers.fluid.entity.FireFluidEffect;
import slimeknights.tconstruct.library.modifiers.fluid.entity.MobEffectFluidEffect;

public abstract class AbstractFluidEffectProvider
extends GenericDataProvider {
    private final String modId;
    private final Map<ResourceLocation, Builder> entries = new HashMap<ResourceLocation, Builder>();

    public AbstractFluidEffectProvider(PackOutput packOutput, String modId) {
        super(packOutput, PackOutput.Target.DATA_PACK, "tinkering/fluid_effects");
        this.modId = modId;
    }

    protected abstract void addFluids();

    public CompletableFuture<?> m_213708_(CachedOutput cache) {
        this.addFluids();
        return AbstractFluidEffectProvider.allOf(this.entries.entrySet().stream().map(entry -> this.saveJson(cache, (ResourceLocation)entry.getKey(), ((Builder)entry.getValue()).build())));
    }

    protected Builder addFluid(ResourceLocation id, FluidIngredient fluid) {
        Builder newBuilder = new Builder(fluid);
        Builder original = this.entries.put(id, newBuilder);
        if (original != null) {
            throw new IllegalArgumentException("Duplicate spilling fluid " + id);
        }
        return newBuilder;
    }

    protected Builder addFluid(String name, FluidIngredient fluid) {
        return this.addFluid(new ResourceLocation(this.modId, name), fluid);
    }

    protected Builder addFluid(FluidStack fluid) {
        return this.addFluid(BuiltInRegistries.f_257020_.m_7981_((Object)fluid.getFluid()).m_135815_(), FluidIngredient.of((FluidStack)fluid));
    }

    protected Builder addFluid(Fluid fluid, int amount) {
        return this.addFluid(BuiltInRegistries.f_257020_.m_7981_((Object)fluid).m_135815_(), (FluidIngredient)FluidIngredient.of((Fluid)fluid, (int)amount));
    }

    protected Builder addFluid(String name, TagKey<Fluid> fluid, int amount) {
        return this.addFluid(name, (FluidIngredient)FluidIngredient.of(fluid, (int)amount));
    }

    protected Builder addFluid(TagKey<Fluid> fluid, int amount) {
        return this.addFluid(fluid.f_203868_().m_135815_(), fluid, amount);
    }

    protected Builder addFluid(FluidObject<?> fluid, boolean commonTag, int amount) {
        return this.addFluid(fluid.getId().m_135815_(), fluid.ingredient(amount, commonTag));
    }

    protected Builder burningFluid(TagKey<Fluid> tag, float damage, int time) {
        return this.burningFluid(tag.f_203868_().m_135815_(), tag, 10, damage, time);
    }

    protected Builder burningFluid(String name, TagKey<Fluid> tag, int amount, float damage, int time) {
        Builder builder = this.addFluid(name, tag, amount).addEntityEffect((IJsonPredicate<LivingEntity>)LivingEntityPredicate.FIRE_IMMUNE.inverted(), new DamageFluidEffect(damage, TinkerDamageTypes.FLUID_FIRE));
        if (time > 0) {
            builder.addEntityEffect(new FireFluidEffect(TimeAction.SET, time)).addBlockEffect(new PlaceBlockFluidEffect(Blocks.f_50083_));
        }
        return builder;
    }

    protected static class Builder {
        private final List<ICondition> conditions = new ArrayList<ICondition>();
        private final FluidIngredient ingredient;
        private final List<FluidEffect<? super FluidEffectContext.Block>> blockEffects = new ArrayList<FluidEffect<? super FluidEffectContext.Block>>();
        private final List<FluidEffect<? super FluidEffectContext.Entity>> entityEffects = new ArrayList<FluidEffect<? super FluidEffectContext.Entity>>();

        public Builder addCondition(ICondition condition) {
            this.conditions.add(condition);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addBlockEffect(FluidEffect<? super FluidEffectContext.Block> effect) {
            this.blockEffects.add(effect);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addEntityEffect(FluidEffect<? super FluidEffectContext.Entity> effect) {
            this.entityEffects.add(effect);
            return this;
        }

        public Builder addEffect(TimeAction action, FluidMobEffect.Builder builder) {
            this.addBlockEffect(builder.buildCloud());
            for (MobEffectFluidEffect effect : builder.buildEntity(action)) {
                this.addEntityEffect(effect);
            }
            return this;
        }

        public Builder addEffect(FluidEffect<FluidEffectContext> effect) {
            this.addBlockEffect(effect);
            this.addEntityEffect(effect);
            return this;
        }

        public Builder addBlockEffect(IJsonPredicate<BlockState> predicate, FluidEffect<? super FluidEffectContext.Block> effect) {
            return this.addBlockEffect(new ConditionalFluidEffect.Block(predicate, effect));
        }

        public Builder addEntityEffect(IJsonPredicate<LivingEntity> predicate, FluidEffect<? super FluidEffectContext.Entity> effect) {
            return this.addEntityEffect(new ConditionalFluidEffect.Entity(predicate, effect));
        }

        private JsonObject build() {
            JsonObject json = new JsonObject();
            if (!this.conditions.isEmpty()) {
                json.add("conditions", (JsonElement)CraftingHelper.serialize((ICondition[])this.conditions.toArray(new ICondition[0])));
            }
            if (this.blockEffects.isEmpty() && this.entityEffects.isEmpty()) {
                throw new IllegalStateException("Must have at least 1 effect");
            }
            FluidEffects.LOADABLE.serialize((Object)new FluidEffects(this.ingredient, this.blockEffects, this.entityEffects), json);
            return json;
        }

        public Builder(FluidIngredient ingredient) {
            this.ingredient = ingredient;
        }
    }
}

