/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.model.block;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import slimeknights.mantle.client.model.inventory.ModelItem;
import slimeknights.mantle.client.model.util.SimpleBlockModel;
import slimeknights.tconstruct.library.client.model.block.IncrementalFluidCuboid;
import slimeknights.tconstruct.library.client.model.block.TankModel;

public class MelterModel
extends TankModel {
    public static final IGeometryLoader<TankModel> LOADER = MelterModel::deserialize;
    private final List<ModelItem> items;

    protected MelterModel(SimpleBlockModel model, @Nullable SimpleBlockModel gui, IncrementalFluidCuboid fluid, List<ModelItem> items) {
        super(model, gui, fluid, false);
        this.items = items;
    }

    @Override
    public BakedModel bake(IGeometryBakingContext owner, ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState transform, ItemOverrides overrides, ResourceLocation location) {
        BakedModel baked;
        BakedModel bakedGui = baked = this.model.bake(owner, baker, spriteGetter, transform, overrides, location);
        if (this.gui != null) {
            bakedGui = this.gui.bake(owner, baker, spriteGetter, transform, overrides, location);
        }
        return new Baked(owner, transform, baked, bakedGui, this);
    }

    public static TankModel deserialize(JsonObject json, JsonDeserializationContext context) {
        SimpleBlockModel model = SimpleBlockModel.deserialize((JsonObject)json, (JsonDeserializationContext)context);
        SimpleBlockModel gui = null;
        if (json.has("gui")) {
            gui = SimpleBlockModel.deserialize((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"gui"), (JsonDeserializationContext)context);
        }
        IncrementalFluidCuboid fluid = IncrementalFluidCuboid.fromJson(GsonHelper.m_13930_((JsonObject)json, (String)"fluid"));
        List items = ModelItem.listFromJson((JsonObject)json, (String)"items");
        return new MelterModel(model, gui, fluid, items);
    }

    public static final class Baked
    extends TankModel.Baked<MelterModel> {
        private Baked(IGeometryBakingContext owner, ModelState transforms, BakedModel baked, BakedModel gui, MelterModel original) {
            super(owner, transforms, baked, gui, original);
        }

        public List<ModelItem> getItems() {
            return ((MelterModel)this.original).items;
        }
    }
}

